import { SetDeviceDebugSettings } from '@signageos/actions/dist/Device/Debug/deviceDebugActions';
import { ReadDeviceDebugSettings } from './deviceDebugLocalActions';

export interface IDebugState {
	debugOn: boolean;
}

const initialState: IDebugState = {
	debugOn: false,
};

export function debug(state: IDebugState = initialState, action: SetDeviceDebugSettings | ReadDeviceDebugSettings) {
	switch (action.type) {
		case SetDeviceDebugSettings:
			return {
				debugOn: action.appletEnabled,
			};
		case ReadDeviceDebugSettings:
			return {
				debugOn: action.debugOn,
			};
		default:
			return state;
	}
}
