import IAction from '@signageos/actions/dist/IAction';

export const PauseAppletTimingTriggers = 'Applet.Timing.PauseTriggers';
export interface PauseAppletTimingTriggers extends IAction<typeof PauseAppletTimingTriggers> {}

export const ResumeAppletTimingTriggers = 'Applet.Timing.ResumeTriggers';
export interface ResumeAppletTimingTriggers extends IAction<typeof ResumeAppletTimingTriggers> {}

export const ShowNextAppletTiming = 'Internal.Timing.ShowNext';
export interface ShowNextAppletTiming extends IAction<typeof ShowNextAppletTiming> {}

export const ShowOSD = 'Internal.Timing.ShowOSD';
export interface ShowOSD extends IAction<typeof ShowOSD> {
	appletBinaryFile: {
		localUri: string;
	};
}

export const ShowOSDTime = 'Internal.Timing.ShowOSDTime';
export interface ShowOSDTime extends IAction<typeof ShowOSDTime> {
	time: number;
}

export const HideOSD = 'Internal.Timing.HideOSD';
export interface HideOSD extends IAction<typeof HideOSD> {}

export const HideApplet = 'Internal.Timing.HideApplet';
export interface HideApplet extends IAction<typeof HideApplet> {}

export const CreateAppletIframe = 'Applet.Timing.CreateAppletIframe';
export interface CreateAppletIframe extends IAction<typeof CreateAppletIframe> {
	uid: string;
	id: string;
}

export const StartAppletIframe = 'Applet.Timing.StartAppletIframe';
export interface StartAppletIframe extends IAction<typeof StartAppletIframe> {
	uid: string;
	id: string;
}

export const RemoveAppletIframe = 'Applet.Timing.RemoveAppletIframe';
export interface RemoveAppletIframe extends IAction<typeof RemoveAppletIframe> {
	id: string;
}

export const PrepareNextAppletTiming = 'Applet.Timing.PrepareNextAppletTiming';
export interface PrepareNextAppletTiming extends IAction<typeof PrepareNextAppletTiming> {
	appletUid: string;
	configuration: any;
	timingChecksum: string;
	appletVersion: string;
	isPackage: boolean;
	appletVersionPostfix?: string;
	appletFrontAppletVersion?: string;
	appletMetadata?: {
		encryptedConfig?: Record<string, string>;
	};
}

export const UpdateNextAppletBinaryFile = 'Applet.Timing.UpdateNextAppletBinaryFile';
export interface UpdateNextAppletBinaryFile extends IAction<typeof UpdateNextAppletBinaryFile> {
	appletUid: string;
	appletBinaryFile: {
		localUri: string;
	} | null;
	appletFrontAppletJsFile: {
		localUri: string;
	} | null;
}
