import TimingFinishEventType from '../AppletTiming/TimingFinishEventType';
import { AppletConfig } from './BundledApplet/bundledAppletActions';

export function getDefaultAppletTimingDefinition(
	appletUid: string,
	appletVersion: string,
	frontAppletVersion: string | undefined,
	checksum: string,
	config: AppletConfig | undefined,
) {
	const DEFAULT_FINISH_EVENT = {
		type: TimingFinishEventType[TimingFinishEventType.DURATION],
		data: null,
	};
	return {
		appletUid,
		configuration: config ?? {},
		timmingChecksum: checksum,
		appletVersion,
		frontAppletVersion,
		finishEvent: DEFAULT_FINISH_EVENT,
		position: 1,
	};
}
