const FRONT_APPLET_JS_UID = 'front-applet';
const LAST_APPLET_BINARY_UID = 'applet';

const createAppletFileNameHelpers = (shortAppletFilesUrl: boolean) => {
	const getLocalDirectoryPath = (appletUid: string, appletVersion: string | null, appletVersionPostfix?: string) => {
		return [LAST_APPLET_BINARY_UID, shortAppletFilesUrl ? appletUid.slice(0, 8) : appletUid, appletVersion ?? 'latest']
			.concat((shortAppletFilesUrl ? appletVersionPostfix?.slice(0, 11) : appletVersionPostfix) ?? [])
			.join('/');
	};
	const getRemoteDirectoryPath = (appletUid: string, appletVersion: string, appletVersionPostfix: string | undefined) => {
		return '/applet' + '/' + appletUid + '/' + appletVersion + (appletVersionPostfix ? '-' + appletVersionPostfix : '');
	};
	return {
		getLocalDirectoryPath,
		getRemoteDirectoryPath,
		getFrontAppletJsFileName: (frontAppletVersion: string) => {
			return FRONT_APPLET_JS_UID + '/' + frontAppletVersion + '.js';
		},
		getAppletBinaryFileName: (appletUid: string, appletVersion: string | null, appletVersionPostfix?: string) => {
			return getLocalDirectoryPath(appletUid, appletVersion, appletVersionPostfix) + '/index.html';
		},
		getAppletPackageFilePath: (appletUid: string, appletVersion: string | null, appletVersionPostfix?: string) => {
			return getLocalDirectoryPath(appletUid, appletVersion, appletVersionPostfix) + '/.package.zip';
		},
		getAppletPackageDirectoryPath: (appletUid: string, appletVersion: string | null, appletVersionPostfix?: string) => {
			return getLocalDirectoryPath(appletUid, appletVersion, appletVersionPostfix) + '/package';
		},
		getAppletPackageConfigFilePath: (appletUid: string, appletVersion: string | null, appletVersionPostfix?: string) => {
			return getLocalDirectoryPath(appletUid, appletVersion, appletVersionPostfix) + '/package/package.json';
		},
		getAppletBinaryFileUri: (staticBaseUrl: string, appletUid: string, appletVersion: string, appletVersionPostfix: string | undefined) => {
			return staticBaseUrl + getRemoteDirectoryPath(appletUid, appletVersion, appletVersionPostfix) + '/index.html';
		},
		getAppletPackageFileUri: (
			staticBaseUrl: string,
			appletUid: string,
			appletVersion: string,
			appletVersionPostfix: string | undefined,
		) => {
			return staticBaseUrl + getRemoteDirectoryPath(appletUid, appletVersion, appletVersionPostfix) + '/.package.zip';
		},
	};
};

export default createAppletFileNameHelpers;
