import { put } from 'redux-saga/effects';
import IPauseTimingTriggersMessage from './IPauseTimingTriggersMessage';
import IResumeTimingTriggersMessage from './IResumeTimingTriggersMessage';
import { PauseAppletTimingTriggers, ResumeAppletTimingTriggers } from '../../AppletTiming/appletTimingActions';
import { HandlerResult, IHandlerParams } from '../IHandler';

export function* handleAppletTimingMessage(messageTypePrefix: string, data: IPauseTimingTriggersMessage | IResumeTimingTriggersMessage) {
	switch (data.type) {
		case messageTypePrefix + '.timing.triggers.pause':
			yield put({
				type: PauseAppletTimingTriggers,
			} as PauseAppletTimingTriggers);
			return {};
		case messageTypePrefix + '.timing.triggers.resume':
			yield put({
				type: ResumeAppletTimingTriggers,
			} as ResumeAppletTimingTriggers);
			return {};
		default:
			return null;
	}
}

export default function* timingHandler({ messageTypePrefix, data }: IHandlerParams): HandlerResult {
	return yield handleAppletTimingMessage(messageTypePrefix, data as IPauseTimingTriggersMessage | IResumeTimingTriggersMessage);
}
