import IFrontDriver from '../../../NativeDevice/Front/IFrontDriver';
import { HandlerResult, IHandlerParams } from '../IHandler';
import IMessage from '../IMessage';
import { putOpenOSD } from '../../Input/osdSagas';
import { IFrontState } from '../../frontReducers';

const OSDMessage = 'hug.osd.show_osd';
export interface OSDMessage extends IMessage {
	type: typeof OSDMessage;
}

const OSD_OPEN_WAIT_TIME = 6e3;

export function* handleOSDMessage(
	messageTypePrefix: string,
	data: OSDMessage,
	frontDriver: IFrontDriver,
	state: IFrontState,
): HandlerResult {
	switch (data.type) {
		case messageTypePrefix + '.osd.show_osd':
			return yield putOpenOSD(frontDriver, state, OSD_OPEN_WAIT_TIME);
		default:
			return null;
	}
}

export default function* osdHandler({ messageTypePrefix, data, frontDriver, getState }: IHandlerParams): HandlerResult {
	const state = getState();
	return yield handleOSDMessage(messageTypePrefix, data as OSDMessage, frontDriver, state);
}
