import IManagementDriver from '../../../NativeDevice/Management/IManagementDriver';
import IPingMessage from '../Main/IPingMessage';
import { HandlerResult, IHandlerParams } from '../IHandler';
import IMonitorsGetListMessage from './IMonitorsGetListMessage';

export function* handleMonitorsMessage(
	messageTypePrefix: string,
	data: IMonitorsGetListMessage,
	nativeDriver: IManagementDriver,
): HandlerResult {
	switch (data.type) {
		case messageTypePrefix + '.monitors.get_list':
			return yield getMonitorsList(nativeDriver);
		default:
			return null;
	}
}

export default function* monitorsHandler({ messageTypePrefix, data, managementDriver }: IHandlerParams): HandlerResult {
	return yield handleMonitorsMessage(messageTypePrefix, data as IPingMessage, managementDriver);
}

async function getMonitorsList(nativeDriver: IManagementDriver) {
	const monitors = await nativeDriver.monitors.getList();
	return { monitors };
}
