import IMessage from '../IMessage';
import ManagementCapability from '../../../NativeDevice/Management/ManagementCapability';
import Orientation from '../../../NativeDevice/Orientation';
import Resolution from '../../../NativeDevice/Resolution';
import VideoOrientation from '../../../Video/Orientation';
import { NativeTimerType } from '@signageos/common-types/dist/Device/Timer/NativeTimerType';
import { ShortWeekdayEnum } from '@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum';
import { ProprietaryTimerType } from '@signageos/common-types/dist/Device/Timer/ProprietaryTimerType';
import { IPeerRecoveryConfiguration } from '../../../NativeDevice/IPeerRecovery';
import { IAutoRecoveryConfiguration } from '../../../NativeDevice/IAutoRecovery';
import { ScheduledRebootRule } from '../../Device/Power/scheduledRules';

export interface IManagementSupportsMessage extends IMessage {
	readonly capability: keyof typeof ManagementCapability;
}

export interface IInitializeMessage extends IMessage {
	readonly staticBaseUrl: string;
}

export interface IAppUpgradeMessage extends IMessage {
	readonly baseUrl?: string;
	readonly version?: string;
	readonly directUri?: string;
}

export interface IUploadScreenshotMessage extends IMessage {
	readonly uploadBaseUrl: string;
	readonly computeHash?: boolean;
}

export interface IFirmwareUpgradeMessage extends IMessage {
	readonly baseUrl?: string;
	readonly version?: string;
	readonly directUri?: string;
}

export interface ISetVolumeMessage extends IMessage {
	readonly volume: number;
}

export interface ISetScreenBrightnessMessage extends IMessage {
	readonly timeFrom1: string;
	readonly brightness1: number;
	readonly timeFrom2: string;
	readonly brightness2: number;
}

export interface IInstallPackageMessage extends IMessage {
	readonly baseUrl: string;
	readonly packageName: string;
	readonly version: string;
	readonly build: string | null;
}

export interface IResizeScreenMessage extends IMessage {
	readonly baseUrl: string;
	readonly orientation: keyof typeof Orientation;
	readonly resolution: keyof typeof Resolution;
	readonly currentVersion: string;
	readonly videoOrientation?: keyof typeof VideoOrientation;
}

export interface IGetTimersMessage extends IMessage {}

export interface ISetTimerMessage extends IMessage {
	readonly timerType: `${NativeTimerType}`;
	readonly timeOn: string | null;
	readonly timeOff: string | null;
	readonly weekdays: ShortWeekdayEnum[];
	readonly volume: number;
}

export interface IGetProprietaryTimersMessage extends IMessage {}

/** Is same as native timers, but no volume set and any timer type number */
export interface ISetProprietaryTimerMessage extends IMessage {
	readonly timerType: ProprietaryTimerType;
	readonly timeOn: string | null;
	readonly timeOff: string | null;
	readonly weekdays: ShortWeekdayEnum[];
	readonly keepAppletRunning?: boolean;
}

export interface IDeleteProprietaryTimerMessage extends IMessage {
	readonly timerType: ProprietaryTimerType;
}

export interface ISetRemoteControlEnabledMessage extends IMessage {
	readonly enabled: boolean;
}

export interface IDateTime {
	year: number;
	month: number;
	day: number;
	hour: number;
	minute: number;
	second: number;
}

export interface ISetManualTimeWithTimezoneMessage extends IMessage {
	readonly currentDate: Date | IDateTime;
	readonly timezone: string;
}

export interface ISetNTPTimeWithTimezoneMessage extends IMessage {
	readonly ntpServer: string;
	readonly timezone: string;
}

export interface ISetDebugMessage extends IMessage {
	readonly enabled: boolean;
}

export type ISetPeerRecoveryMessage = IMessage & IPeerRecoveryConfiguration;

export type ISetAutoRecoveryMessage = IMessage & IAutoRecoveryConfiguration;

export interface IGetExtendedManagementUrl extends IMessage {}
export interface ISetExtendedManagementUrl extends IMessage {
	url: string;
}

export interface IGetScreenBrightnessMessage extends IMessage {}
export interface IGetApplicationTypeMessage extends IMessage {}
export interface IGetApplicationVersionMessage extends IMessage {}
export interface IGetModelMessage extends IMessage {}
export interface IGetSerialNumberMessage extends IMessage {}
export interface IGetBatteryStatusMessage extends IMessage {}
export interface IGetCurrentTemperatureMessage extends IMessage {}
export interface IGetFirmwareVersionMessage extends IMessage {}
export interface IGetFirmwareTypeMessage extends IMessage {}
export interface IGetVolumeMessage extends IMessage {}
export interface IRebootSystemMessage extends IMessage {}
export interface IRestartAppMessage extends IMessage {}
export interface IPowerOnDisplayMessage extends IMessage {}
export interface IPowerOffDisplayMessage extends IMessage {}
export interface IGetIsDisplayPowerOnMessage extends IMessage {}
export interface IGetIsRemoteControlEnabledMessage extends IMessage {}
export interface IGetCurrentTimeWithTimezoneMessage extends IMessage {}
export interface IResetSettingsMessage extends IMessage {}
export interface IFactoryResetMessage extends IMessage {}
export interface IGetPinCodeMessage extends IMessage {}
export interface ISetPinCodeMessage extends IMessage {
	pinCode: string;
}
export interface IGetPeerRecoveryMessage extends IMessage {}
export interface IGetAutoRecoveryMessage extends IMessage {}
export interface IGetBrandMessage extends IMessage {}
export interface ISetHardwareAccelerationMessage extends IMessage {
	enabled: boolean;
}
export interface IIsHardwareAccelerationEnabledMessage extends IMessage {}
export interface SetScheduledRebootActionMessage extends IMessage {
	readonly rule: ScheduledRebootRule;
}
export interface RemoveScheduledRebootMessage extends IMessage {
	readonly id: string;
}
