import { StartApplication } from '@signageos/actions/dist/Application/applicationActions';
import { takeEvery } from 'redux-saga/effects';
import { WifiEvent } from '../../../../NativeDevice/Hardware/IWifi';
import { IFrontManagementDriver } from '../../../../NativeDevice/Management/IManagementDriver';
import ManagementCapability from '../../../../NativeDevice/Management/ManagementCapability';
import { createChannel, takeEvery as takeEveryChannelMessage } from '../../../../ReduxSaga/channels';
import { IFrontState } from '../../../frontReducers';
import { sendMessageToActiveAppletIfExists } from '../../sendAppletMessage';

export function* wifiEventEmitting(
	window: Window,
	messageTypePrefix: string,
	getNativeDriver: () => IFrontManagementDriver,
	getState: () => IFrontState,
) {
	yield takeEvery(StartApplication, function* () {
		const nativeDriver = getNativeDriver();
		const supportsWifi: boolean = yield nativeDriver.managementSupports(ManagementCapability.WIFI);
		if (supportsWifi) {
			const wifiEventsChannel = createWifiChannel(getNativeDriver);
			yield takeEveryChannelMessage(wifiEventsChannel, function* (event: WifiEvent) {
				yield sendMessageToActiveAppletIfExists(window, getState, {
					type: messageTypePrefix + '.management.wifi.event_' + event,
				});
			});
		}
	});
}

function createWifiChannel(getNativeDriver: () => IFrontManagementDriver) {
	const nativeDriver = getNativeDriver();
	const events = [
		WifiEvent.CLIENT_ENABLED,
		WifiEvent.CLIENT_CONNECTED,
		WifiEvent.CLIENT_CONNECT_REJECTED,
		WifiEvent.CLIENT_DISCONNECTED,
		WifiEvent.AP_ENABLED,
		WifiEvent.DISABLED,
	];
	return createChannel((putEvent: (message: WifiEvent) => void) => {
		for (const event of events) {
			nativeDriver.wifi.on(event, () => putEvent(event));
		}
	});
}
