import IManagementDriver from '../../../../NativeDevice/Management/IManagementDriver';
import { HandlerResult, IHandlerParams } from '../../IHandler';
import { IGetOSInfoMessage, IGetCpuUsageMessage, IGetMemoryUsageMessage } from './messageTypes';

const PREFIX = 'management';

export function* handleManagementSystemInfoMessage(
	messageTypePrefix: string,
	data: IGetOSInfoMessage | IGetCpuUsageMessage | IGetMemoryUsageMessage,
	managementDriver: IManagementDriver,
): HandlerResult {
	switch (data.type) {
		case `${messageTypePrefix}.${PREFIX}.get_os_info`:
			return yield handleOSInfo(managementDriver);

		case `${messageTypePrefix}.${PREFIX}.get_cpu_usage`:
			return yield handleCpuUsage(managementDriver);

		case `${messageTypePrefix}.${PREFIX}.get_memory_usage`:
			return yield handleMemoryUsage(managementDriver);

		default:
			return null;
	}
}

async function handleOSInfo(managementDriver: IManagementDriver) {
	const osVersion = await managementDriver.systemInfo.getOSVersion();
	return {
		osInfo: {
			version: osVersion,
		},
	};
}

async function handleCpuUsage(managementDriver: IManagementDriver) {
	const cpuUsage = await managementDriver.systemInfo.getCpuUsage();
	return {
		cpuUsage,
	};
}

async function handleMemoryUsage(managementDriver: IManagementDriver) {
	const memoryUsage = await managementDriver.systemInfo.getMemoryUsage();
	return {
		memoryUsage,
	};
}

export default function* managementHandler({ messageTypePrefix, data, managementDriver }: IHandlerParams): HandlerResult {
	return yield handleManagementSystemInfoMessage(
		messageTypePrefix,
		data as IGetOSInfoMessage | IGetCpuUsageMessage | IGetMemoryUsageMessage,
		managementDriver,
	);
}
