import IMessage from '../../IMessage';
import { NetworkInterfacesTypes } from '@signageos/common-types/dist/Device/Network/NetworkInterface';

export interface IGetNetworkInfoMessage extends IMessage {}
export interface IGetNetworkInterfacesMessage extends IMessage {}

export interface ISetNetworkManualMessage extends IMessage {
	interfaceName: string;
	options: {
		interface: NetworkInterfacesTypes;
		localAddress: string;
		gateway: string;
		netmask: string;
		dns: string[];
	};
}

export interface ISetNetworkDHCPMessage extends IMessage {
	interfaceName: string;
}

export interface ISetNetworkManualLegacyMessage extends IMessage {
	options: {
		interface: NetworkInterfacesTypes;
		localAddress: string;
		gateway: string;
		netmask: string;
		dns: string[];
	};
}

export interface ISetNetworkDHCPLegacyMessage extends IMessage {
	networkInterface: NetworkInterfacesTypes;
}

export interface IDisableNetworkInterfaceMessage extends IMessage {
	interfaceName: string;
}
