import IHardwareLedSetColorMessage from './IHardwareLedSetColorMessage';
import IDriver from '../../../NativeDevice/Front/IFrontDriver';
import InternalHardwareError from '../Error/InternalHardwareError';
import ErrorCodes from '../Error/ErrorCodes';
import { HandlerResult, IHandlerParams } from '../IHandler';

export function* handleHardwareMessage(
	messageTypePrefix: string,
	data: IHardwareLedSetColorMessage,
	nativeDriver: IDriver,
	_appletUid: string,
	_timingChecksum: string,
) {
	switch (data.type) {
		case messageTypePrefix + '.hardware.led.set_color':
			try {
				yield nativeDriver.hardware.led.setColor(data.color);
			} catch (error) {
				throw new InternalHardwareError({
					kind: 'internalHardwareErrorWithOrigin',
					message: 'Unexpected error occurred when working with hardware.',
					code: ErrorCodes.HARDWARE_SET_COLOR_ERROR,
					origin: `setColor(${data.color})`,
					originStack: error.stack,
					originMessage: error.message,
				});
			}
			return {};
		default:
			return null;
	}
}

export default function* hardwareHandler({
	messageTypePrefix,
	data,
	frontDriver,
	appletUid,
	timingChecksum,
}: IHandlerParams): HandlerResult {
	return yield handleHardwareMessage(messageTypePrefix, data as IHardwareLedSetColorMessage, frontDriver, appletUid, timingChecksum);
}
