import { takeEvery } from 'redux-saga/effects';
import { IFrontState } from '../../frontReducers';
import { sendMessageToActiveAppletIfExists } from '../sendAppletMessage';
import IFrontDriver from '../../../NativeDevice/Front/IFrontDriver';
import { StartApplication } from '@signageos/actions/dist/Application/applicationActions';
import { createChannel, takeEvery as takeEventChannelMessage } from '../../../ReduxSaga/channels';

export function* storageStatusChangeEmitting(
	window: Window,
	messageTypePrefix: string,
	getNativeDriver: () => IFrontDriver,
	getState: () => IFrontState,
) {
	yield takeEvery(StartApplication, function* () {
		try {
			const nativeDriver = getNativeDriver();
			const storageChangesChannel = createChannel<undefined>((put: (message: undefined) => void) =>
				nativeDriver.fileSystem.onStorageUnitsChanged(() => put(undefined)),
			);
			yield takeEventChannelMessage(storageChangesChannel, function* () {
				yield sendMessageToActiveAppletIfExists(window, getState, {
					type: messageTypePrefix + '.file_system.storage_units_changed',
				});
			});
		} catch (error) {
			console.error('storageStatusChangeEmitting failed', error);
		}
	});
}
