import ErrorCodes from './ErrorCodes';

export interface ISosErrorTransferObject {
	type: string;
	code: string;
	message: string;
	suggestion?: string;
	stackTrace?: string;
	pathToDocs?: string;
	origin?: string;
	originStack?: string;
}

export function createErrorTransferObject(error: any): ISosErrorTransferObject {
	const errorTransferObject = {} as ISosErrorTransferObject;

	errorTransferObject.type = error.name;
	errorTransferObject.message = error.message;
	errorTransferObject.stackTrace = error.stack;
	errorTransferObject.suggestion = error.suggestion;
	errorTransferObject.pathToDocs = error.pathToDocs;
	errorTransferObject.origin = error.origin;
	errorTransferObject.originStack = error.originStack;
	errorTransferObject.code = error.code ? error.code : ErrorCodes.UNEXPECTED_EXCEPTION;

	return errorTransferObject;
}
