import InternalError, { IBaseInternalErrorParamsWithOrigin } from './InternalError';
import { IBaseSosErrorParams } from './SosError';

export interface IInternalFileSystemErrorParams extends IBaseSosErrorParams {
	kind: 'internalFileSystemError';
}

export interface IInternalFileSystemErrorParamsWithOrigin extends IBaseInternalErrorParamsWithOrigin {
	kind: 'internalFileSystemErrorWithOrigin';
}

export default class InternalFileSystemError extends InternalError {
	public static readonly PATH_TO_DOCS: string = '/api/js/js-file-system';

	constructor(parameters: IInternalFileSystemErrorParams | IInternalFileSystemErrorParamsWithOrigin) {
		if (parameters.kind === 'internalFileSystemError') {
			super({
				...parameters,
				pathToDocs: InternalFileSystemError.PATH_TO_DOCS,
				kind: 'internalError',
			});
		} else {
			super({
				...parameters,
				pathToDocs: InternalFileSystemError.PATH_TO_DOCS,
				kind: 'internalErrorWithOrigin',
			});
		}
		this.name = 'InternalFileSystemError';
	}
}
