import SosError, { IBaseSosErrorParams, IBaseSosErrorParamsWithDocs } from './SosError';

export interface IBaseInternalErrorParamsWithOrigin extends IBaseSosErrorParams {
	origin: string;
	originStack: string;
	originMessage: string;
}

export interface IInternalErrorParams extends IBaseSosErrorParamsWithDocs {
	kind: 'internalError';
}

export interface IInternalErrorParamsWithOrigin extends IBaseSosErrorParamsWithDocs {
	kind: 'internalErrorWithOrigin';
	origin: string;
	originStack: string;
	originMessage: string;
}

export default class InternalError extends SosError {
	public origin?: string;
	public originStack?: string;
	public originMessage?: string;

	constructor(parameters: IInternalErrorParams | IInternalErrorParamsWithOrigin) {
		const { message, code, suggestion, pathToDocs } = parameters;
		const originMessage = parameters.kind === 'internalErrorWithOrigin' ? parameters.originMessage : undefined;
		super({
			kind: 'sosError',
			message: `${message}${originMessage ? ' - Original: ' + originMessage : ''}`,
			code,
			suggestion,
			pathToDocs,
		});
		this.name = 'InternalError';
		this.origin = parameters.kind === 'internalErrorWithOrigin' ? parameters.origin : undefined;
		this.originStack = parameters.kind === 'internalErrorWithOrigin' ? parameters.originStack : undefined;
		this.originMessage = originMessage;
	}
}
