import InternalError, { IBaseInternalErrorParamsWithOrigin } from './InternalError';
import { IBaseSosErrorParams } from './SosError';

export interface IInternalBrowserErrorParams extends IBaseSosErrorParams {
	kind: 'internalBrowserError';
}

export interface IInternalBrowserErrorParamsWithOrigin extends IBaseInternalErrorParamsWithOrigin {
	kind: 'internalBrowserErrorWithOrigin';
}

export default class InternalBrowserError extends InternalError {
	public static readonly PATH_TO_DOCS: string = '/api/js/js-browser';

	constructor(parameters: IInternalBrowserErrorParams | IInternalBrowserErrorParamsWithOrigin) {
		if (parameters.kind === 'internalBrowserError') {
			super({
				...parameters,
				pathToDocs: InternalBrowserError.PATH_TO_DOCS,
				kind: 'internalError',
			});
		} else {
			super({
				...parameters,
				pathToDocs: InternalBrowserError.PATH_TO_DOCS,
				kind: 'internalErrorWithOrigin',
			});
		}
		this.name = 'InternalBrowserOpenLinkError';
	}
}
