import AppletError from './AppletError';
import { IBaseSosErrorParams } from './SosError';

export interface IAppletSecurityErrorParams extends IBaseSosErrorParams {
	kind: 'appletSecurityError';
}

export default class AppletSecurityError extends AppletError {
	public static readonly PATH_TO_DOCS: string = '/api/js/management/12-js-management-security';

	constructor(parameters: IAppletSecurityErrorParams) {
		super({
			...parameters,
			pathToDocs: AppletSecurityError.PATH_TO_DOCS,
			kind: 'appletError',
		});
	}
}
