import AppletError from './AppletError';
import { IBaseSosErrorParams } from './SosError';

export interface IAppletNativeCacheErrorParams extends IBaseSosErrorParams {
	kind: 'appletNativeCacheError';
}

export default class AppletNativeCacheError extends AppletError {
	public static readonly PATH_TO_DOCS: string = '/api/js/js-command';

	constructor(parameters: IAppletNativeCacheErrorParams) {
		super({
			...parameters,
			pathToDocs: AppletNativeCacheError.PATH_TO_DOCS,
			kind: 'appletError',
		});
		this.name = 'AppletNativeCacheError';
	}
}
