import { IFrontState } from '../../frontReducers';
import { now } from '@signageos/lib/dist/DateTime/dateTimeFactory';
import wait from '@signageos/lib/dist/Timer/wait';
import { StartApplication } from '@signageos/actions/dist/Application/applicationActions';
import { sendMessageToActiveAppletIfExists } from '../sendAppletMessage';
import { takeEvery } from 'redux-saga/effects';

export function* currentTimestampEmiting(window: Window, messageTypePrefix: string, getState: () => IFrontState) {
	yield takeEvery(StartApplication, function* () {
		while (true) {
			const currentTimestamp = now().valueOf();
			yield sendMessageToActiveAppletIfExists(window, getState, {
				type: messageTypePrefix + '.date_time.current_timestamp',
				currentTimestamp,
			});
			yield wait(3e3);
		}
	});
}
