import { put } from 'redux-saga/effects';
import ICommandDispatchMessage from './ICommandDispatchMessage';
import IDriver from '../../../NativeDevice/Front/IFrontDriver';
import { ActiveAppletDispatchCommand } from '@signageos/actions/dist/Applet/activeAppletActions';
import AppletCommandError from '../Error/AppletCommandError';
import ErrorCodes from '../Error/ErrorCodes';
import { HandlerResult, IHandlerParams } from '../IHandler';

export function* handleCommandMessage(
	messageTypePrefix: string,
	data: ICommandDispatchMessage,
	_nativeDriver: IDriver,
	appletUid: string,
	timingChecksum: string,
) {
	switch (data.type) {
		case messageTypePrefix + '.command.dispatch':
			if (typeof data.command.type !== 'string') {
				throw new AppletCommandError({
					kind: 'appletCommandError',
					message: 'Command type must be a string.',
					code: ErrorCodes.COMMAND_TYPE_IS_NOT_STRING,
				});
			}
			yield put({
				type: ActiveAppletDispatchCommand,
				appletUid,
				timingChecksum,
				command: data.command,
			} as ActiveAppletDispatchCommand);
			return {};
		default:
			return null;
	}
}

export default function* commandHandler({
	messageTypePrefix,
	data,
	frontDriver,
	appletUid,
	timingChecksum,
}: IHandlerParams): HandlerResult {
	return yield handleCommandMessage(messageTypePrefix, data as ICommandDispatchMessage, frontDriver, appletUid, timingChecksum);
}
