import { takeEveryAndBindWhenPlatform } from '../../../Socket/socketActionCreator';
import { DispatchCommandToApplet } from '@signageos/actions/dist/Applet/activeAppletActions';
import { IFrontState } from '../../frontReducers';
import { sendMessageToActiveAppletIfExists } from '../sendAppletMessage';
import { IBundledApplet } from '../BundledApplet/bundledAppletActions';
import Debug from 'debug';
const debug = Debug('@signageos/front-display:Front:Applet:Command:appletCommandDispatchSagas');

export function* dispatchAppletCommandToApplet(
	messageTypePrefix: string,
	window: Window,
	getState: () => IFrontState,
	bundledApplet: IBundledApplet | null,
) {
	yield takeEveryAndBindWhenPlatform(DispatchCommandToApplet, function* (action: DispatchCommandToApplet) {
		try {
			const activeAppletUid = getState().applet.activeAppletUid;
			if (activeAppletUid !== action.appletUid && activeAppletUid !== bundledApplet?.uid) {
				throw new Error(
					`Dispatching timing command to applet is not permited because of appletUid ${activeAppletUid} !== ${action.appletUid}`,
				);
			}
			const command = action.command;
			yield sendMessageToActiveAppletIfExists(window, getState, {
				type: messageTypePrefix + '.command.dispatch_to_applet',
				command,
			});
		} catch (error) {
			debug('dispatchAppletCommandToApplet failed', error);
		}
	});
}
