import { NotifyBundledApplet, IBundledApplet } from './bundledAppletActions';

export interface IBundledAppletState {
	bundledApplet: IBundledApplet | null;
}

const initialState: IBundledAppletState = {
	bundledApplet: null,
};

export function bundledApplet(state: IBundledAppletState = initialState, action: NotifyBundledApplet) {
	switch (action.type) {
		case NotifyBundledApplet:
			return {
				...state,
				bundledApplet: action.bundledApplet,
			};
		default:
			return state;
	}
}
