import { take } from 'redux-saga/effects';
import { IFrontState } from '../../frontReducers';
import { sendMessageToActiveAppletIfExists } from '../sendAppletMessage';
import { CloseEvent, EventType } from '../../../NativeDevice/IBrowser';
import IFrontDriver from '../../../NativeDevice/Front/IFrontDriver';
import { StopApplication } from '../../../Application/applicationActions';

export function* browserEventEmitting(
	window: Window,
	messageTypePrefix: string,
	getNativeDriver: () => IFrontDriver,
	getState: () => IFrontState,
) {
	const browser = getNativeDriver().browser;
	const supports: boolean = yield browser.isSupported();
	if (!supports) {
		return;
	}

	const closeListener = (event: CloseEvent) => {
		sendMessageToActiveAppletIfExists(window, getState, {
			type: messageTypePrefix + '.browser.closed',
			reason: event.reason,
		});
	};
	browser.addListener(EventType.CLOSE, closeListener);
	try {
		yield take(StopApplication);
	} finally {
		browser.removeListener(EventType.CLOSE, closeListener);
	}
}
