import IDeviceFirmwareVersionFactory, { IDeviceFirmwareVersion } from '../NativeDevice/IDeviceFirmwareVersion';
import crypto from 'crypto';

const randomSemver = () => `${Math.floor(Math.random() * 10)}.${Math.floor(Math.random() * 10)}.${Math.floor(Math.random() * 10)}`;

export default class MockDeviceFirmwareVersionFactory implements IDeviceFirmwareVersionFactory {
	public createFirmwareVersion(deviceUid: string, applicationType: string, version: string): IDeviceFirmwareVersion {
		return {
			uid: crypto.randomUUID(),
			deviceUid: deviceUid,
			firmware: {
				applicationType: applicationType,
				createdAt: new Date(),
				uid: crypto.randomUUID(),
				version: version,
			},
		};
	}

	public async getFirmwareVersion(deviceUid: string, applicationType: string): Promise<IDeviceFirmwareVersion> {
		return this.createFirmwareVersion(deviceUid, applicationType, randomSemver());
	}
}
