import { IFilePath } from '../NativeDevice/fileSystem';

export class FileDoesNotExistError extends Error {
	constructor(public readonly filePath: IFilePath) {
		super(`File does not exist: ${filePath.storageUnit.type} - ${filePath.filePath}`);
		Object.setPrototypeOf(this, FileDoesNotExistError.prototype);
	}
}

export class FileAlreadyExistsError extends Error {
	constructor(public readonly filePath: IFilePath) {
		super(`File already exists: ${filePath.storageUnit.type} - ${filePath.filePath}`);
		Object.setPrototypeOf(this, FileAlreadyExistsError.prototype);
	}
}

export class DirectoryIsNotWritableError extends Error {
	constructor(public readonly filePath: IFilePath) {
		super(`Path is directory that is not writable: ${filePath.storageUnit.type} - ${filePath.filePath}`);
		Object.setPrototypeOf(this, DirectoryIsNotWritableError.prototype);
	}
}

export class DirectoryIsNotReadableError extends Error {
	constructor(public readonly filePath: IFilePath) {
		super(`Path is directory that is not readable: ${filePath.storageUnit.type} - ${filePath.filePath}`);
		Object.setPrototypeOf(this, DirectoryIsNotReadableError.prototype);
	}
}

export class FileIsNotListableError extends Error {
	constructor(public readonly directoryPath: IFilePath) {
		super(`Path is file that is not listable: ${directoryPath.storageUnit.type} - ${directoryPath.filePath}`);
		Object.setPrototypeOf(this, FileIsNotListableError.prototype);
	}
}

export class DirectoryIsNotEmptyError extends Error {
	constructor(public readonly directoryPath: IFilePath) {
		super(`Directory is not empty: ${directoryPath.storageUnit.type} - ${directoryPath.filePath}`);
		Object.setPrototypeOf(this, DirectoryIsNotEmptyError.prototype);
	}
}

export class RootDirectoryIsNotDeletableError extends Error {
	constructor(public readonly directoryPath: IFilePath) {
		super(`Root directory is not deletable: ${directoryPath.storageUnit.type} - ${directoryPath.filePath}`);
		Object.setPrototypeOf(this, RootDirectoryIsNotDeletableError.prototype);
	}
}

export class InvalidFileStateError extends Error {
	constructor(public readonly filePath: IFilePath) {
		super(`Invalid internal state of fileSystem that cannot be resolved: ${filePath.storageUnit.type} - ${filePath.filePath}`);
		Object.setPrototypeOf(this, InvalidFileStateError.prototype);
	}
}
