import { Saga, SagaIterator } from 'redux-saga';
import { all, call } from 'redux-saga/effects';
import { withDependencies } from '../DI/dependencyInjection';
import FrontCapability from '../NativeDevice/Front/FrontCapability';
import ManagementCapability from '../NativeDevice/Management/ManagementCapability';
import { OneOrMany } from '../Types/array';

export const whenCapable = <Args extends unknown[]>(requiredCapabilities: OneOrMany<ManagementCapability>, saga: Saga<Args>) =>
	withDependencies(['managementDriver'], function* ({ managementDriver }, ...args: Args): SagaIterator {
		requiredCapabilities = requiredCapabilities instanceof Array ? requiredCapabilities : [requiredCapabilities];
		const capableOfList: boolean[] = yield all(requiredCapabilities.map((cap) => call(() => managementDriver.managementSupports(cap))));
		if (capableOfList.every((capable) => capable)) {
			yield call(saga, ...args);
		}
	});

export const whenFrontCapable = <Args extends unknown[]>(requiredCapabilities: OneOrMany<FrontCapability>, saga: Saga<Args>) =>
	withDependencies(['frontDriver'], function* ({ frontDriver }, ...args: Args): SagaIterator {
		requiredCapabilities = requiredCapabilities instanceof Array ? requiredCapabilities : [requiredCapabilities];
		const capableOfList: boolean[] = yield all(requiredCapabilities.map((cap) => call(() => frontDriver.frontSupports(cap))));
		if (capableOfList.every((capable) => capable)) {
			yield call(saga, ...args);
		}
	});
