import { VerificationHashCreated, VerificationSucceeded } from '@signageos/actions/dist/Device/Verification/deviceVerificationActions';

export interface IDeviceVerificationState {
	verificationHash: string | null;
	verified: boolean | null;
}

const initialState: IDeviceVerificationState = {
	verificationHash: null,
	verified: null,
};

export function deviceVerification(
	state: IDeviceVerificationState = initialState,
	action: VerificationHashCreated | VerificationSucceeded,
) {
	switch (action.type) {
		case VerificationHashCreated:
			return {
				...state,
				verificationHash: action.verificationHash,
				verified: false,
			};
		case VerificationSucceeded:
			return {
				...state,
				verified: true,
				processDoneOnce: true,
			};
		default:
			return state;
	}
}
