import { put, take, takeEvery } from 'redux-saga/effects';
import {
	CancelScheduledPowerAction,
	CancelScheduledPowerActionFailed,
	CancelScheduledPowerActionSucceed,
	SchedulePowerAction,
	SchedulePowerActionFailed,
	SchedulePowerActionSucceed,
} from '@signageos/actions/dist/Device/Power/devicePowerActions';
import PowerActionType from '@signageos/actions/dist/Device/Power/PowerActionType';
import IPowerActionTimer, { PowerActionRule } from '../../NativeDevice/Power/IPowerActionTimer';
import { unsetByFilter } from '../../NativeDevice/Power/powerActionTimers';
import { StopApplication } from '../../Application/applicationActions';

export function* deviceSchedulePowerActionCommon(
	powerActionTimer: IPowerActionTimer,
	shouldHandle: (powerType: PowerActionType) => boolean,
) {
	// Trigger storage migration and drop unsupported power action types.
	yield unsetByFilter(powerActionTimer, (rule: PowerActionRule) => {
		return !shouldHandle(rule.powerType);
	});

	yield powerActionTimer.notifyStart();
	try {
		// Actions need to be bound by consumers.
		yield takeEvery(SchedulePowerAction, function* (action: SchedulePowerAction) {
			try {
				if (!shouldHandle(action.powerType)) {
					return;
				}
				const { uid, ...rule } = action;
				yield powerActionTimer.set(uid, rule);
				yield put({
					type: SchedulePowerActionSucceed,
					uid: action.uid,
				});
			} catch (error) {
				yield put({
					type: SchedulePowerActionFailed,
					uid: action.uid,
				});
			}
		});
		yield takeEvery(CancelScheduledPowerAction, function* (action: CancelScheduledPowerAction) {
			try {
				const uid = action.scheduledPowerActionUid;
				yield powerActionTimer.unset(uid);
				yield put({
					type: CancelScheduledPowerActionSucceed,
					uid: action.uid,
				});
			} catch (error) {
				yield put({
					type: CancelScheduledPowerActionFailed,
					uid: action.uid,
				});
			}
		});
		yield take(StopApplication);
	} finally {
		yield powerActionTimer.notifyEnd();
	}
}
