import { call, put } from 'redux-saga/effects';
import { NotifyCurrentTime } from '@signageos/actions/dist/Device/DateTime/deviceDateTimeActions';
import { getCurrentTime, ITimeWithTimezone } from '../../Management/Device/DateTime/dateTimeFacade';
import { withDependencies } from '../../DI/dependencyInjection';
import { SagaIterator } from '@redux-saga/types';

export const notifyCurrentTime = withDependencies(['managementDriver', 'propertyStorage'], function* ({ managementDriver }): SagaIterator {
	try {
		const currentTimeWithTimezone: ITimeWithTimezone = yield call(getCurrentTime, managementDriver);

		yield put<NotifyCurrentTime>({
			type: NotifyCurrentTime,
			...currentTimeWithTimezone,
		});
	} catch (error) {
		console.error('startupDeviceDateTimeSettings', error);
	}
});
