export type ITelemetryIntervals = {
	/** interval of period in milliseconds greater than zero while zero means disposable or -1 means disabled */
	[intervalType in IntervalType]: number;
};

export enum IntervalType {
	SCREENSHOTS = 'screenshots',
	TEMPERATURE = 'temperature',
	APPLICATION_VERSION = 'applicationVersion',
	BRIGHTNESS = 'brightness',
	DATETIME = 'datetime',
	DEBUG = 'debug',
	FIRMWARE_VERSION = 'firmwareVersion',
	ORIENTATION = 'orientation',
	POWER_ACTIONS_SCHEDULE = 'powerActionsSchedule',
	PROPRIETARY_TIMERS = 'proprietaryTimers',
	REMOTE_CONTROL = 'remoteControl',
	RESOLUTION = 'resolution',
	TIMERS = 'timers',
	VOLUME = 'volume',
	STORAGE = 'storage',
	BATTERY = 'battery',
	BUNDLED_APPLET = 'bundledApplet',
	POLICY = 'policy',
	DEFAULT = 'default',
	PROXY = 'proxy',
	WIFI_STRENGTH = 'wifiStrength',
	AUTO_RECOVERY = 'autoRecovery',
	PEER_RECOVERY = 'peerRecovery',
	MANAGEMENT_CAPABILITIES = 'managementCapabilities',
	NETWORK_INTERFACES = 'networkInterfaces',
	DISPLAY_POWER_ON = 'displayPowerOn',
	APP_MODULES = 'appModules',
	FEATURE_FLAGS = 'featureFlags',
	CRYPTOGRAPHIC_KEY = 'cryptographicKey',
	EXTENDED_MANAGEMENT_URL = 'extendedManagementUrl',
}

export const defaultTelemetryIntervals: ITelemetryIntervals = {
	[IntervalType.SCREENSHOTS]: 6 * 60e3,
	[IntervalType.TEMPERATURE]: 5 * 60e3,
	[IntervalType.BRIGHTNESS]: 10 * 60e3,
	[IntervalType.DATETIME]: 10 * 60e3,
	[IntervalType.DEBUG]: 10 * 60e3,
	[IntervalType.ORIENTATION]: 10 * 60e3,
	[IntervalType.POWER_ACTIONS_SCHEDULE]: 10 * 60e3,
	[IntervalType.PROPRIETARY_TIMERS]: 10 * 60e3,
	[IntervalType.REMOTE_CONTROL]: 10 * 60e3,
	[IntervalType.RESOLUTION]: 10 * 60e3,
	[IntervalType.TIMERS]: 10 * 60e3,
	[IntervalType.VOLUME]: 10 * 60e3,
	[IntervalType.STORAGE]: 20 * 60e3,
	[IntervalType.BATTERY]: 20 * 60e3,
	[IntervalType.APPLICATION_VERSION]: 0,
	[IntervalType.FIRMWARE_VERSION]: 0,
	[IntervalType.BUNDLED_APPLET]: 0,
	[IntervalType.POLICY]: 1 * 60e3,
	[IntervalType.DEFAULT]: 10 * 60e3,
	[IntervalType.PROXY]: 10 * 60e3,
	[IntervalType.WIFI_STRENGTH]: 10 * 60e3,
	[IntervalType.AUTO_RECOVERY]: 10 * 60e3,
	[IntervalType.PEER_RECOVERY]: 10 * 60e3,
	[IntervalType.MANAGEMENT_CAPABILITIES]: 0,
	[IntervalType.NETWORK_INTERFACES]: 10 * 60e3,
	[IntervalType.DISPLAY_POWER_ON]: 10 * 60e3,
	[IntervalType.APP_MODULES]: 10 * 60e3,
	[IntervalType.FEATURE_FLAGS]: 10 * 60e3,
	[IntervalType.CRYPTOGRAPHIC_KEY]: 10 * 60e3,
	[IntervalType.EXTENDED_MANAGEMENT_URL]: 10 * 60e3,
};

export function areTelemetryIntervalsSame(a: ITelemetryIntervals | undefined | null, b: ITelemetryIntervals | undefined | null) {
	return a === b || Object.values(IntervalType).every((it: IntervalType) => a?.[it] === b?.[it]);
}
