import { DeviceFeatureFlag } from '@signageos/common-types/dist/Device/FeatureFlag';

export type DeviceFeatureFlagRecord = Record<DeviceFeatureFlag, boolean>;

function getDefaultDeviceFeatureFlags(): DeviceFeatureFlagRecord {
	return Object.keys(DeviceFeatureFlag).reduce((prev: DeviceFeatureFlagRecord, current: DeviceFeatureFlag): DeviceFeatureFlagRecord => {
		// Declaring variable as 'never' and assigning it current value in default branch of switch will prevent us
		// from forgetting to add other feature flags when they are added into DeviceFeatureFlag enum in future
		// @ts-ignore
		let _neverFeatureFlag: never;
		switch (current) {
			case DeviceFeatureFlag.ScreenshotCapture:
				prev[DeviceFeatureFlag.ScreenshotCapture] = true;
				return prev;
			default:
				// tsc will throw error when new feature flag is added, and it's not reflected in this switch
				_neverFeatureFlag = current;
				return prev;
		}
	}, {} as DeviceFeatureFlagRecord);
}

export const defaultFeatureFlags = getDefaultDeviceFeatureFlags();
