// For browser, the crypto package cannot be used because is polyfilled with crypto-browserify,
// which has different implementation than node.js crypto.
import * as jsrsasign from 'jsrsasign';

export interface ISignedResponse {
	/**
	 * Unique random identifier to prvent brute-force attacks on message signature
	 */
	responseUid: string;
	/**
	 * Signature is generated from PEM-formatted private key and serialized JSON-body of message
	 */
	signature: string;
	/**
	 * Arbitrary key-value pairs that will be send within response
	 */
	[key: string]: any;
}

export function isConfigResponseVerified<T extends ISignedResponse>(data: T, publicKey: string): boolean {
	try {
		const { signature: signatureBase64, ...dataWithoutAuth } = data;
		const signedMessage = JSON.stringify(dataWithoutAuth);
		const sig = new jsrsasign.KJUR.crypto.Signature({
			alg: 'SHA256withRSA',
		});
		sig.init(publicKey);
		sig.updateString(signedMessage);
		const signatureHex = Buffer.from(signatureBase64, 'base64').toString('hex');
		return sig.verify(signatureHex);
	} catch (error) {
		console.warn(error);
		return false;
	}
}
