import { ActionsLimit } from '@signageos/common-types/dist/Device/Actions/ActionLimit';
import { SubscriptionType } from '../../Display/IConfig';
import { FetchError } from '../../Isomorphic/fetch';
import { ITelemetryIntervals } from './telemetryIntervals';
import { DeviceFeatureFlagRecord } from './featureFlags';

export const CheckDeviceConfiguration = 'Device.Configuration.CheckDeviceConfiguration';
export interface CheckDeviceConfiguration {
	type: typeof CheckDeviceConfiguration;
}

/** @deprecated use injectDependencies subscriptionType instead */
export const ChangeSubscriptionToOpen = 'Device.Configuration.ChangeSubscriptionToOpen';
export interface ChangeSubscriptionToOpen {
	type: typeof ChangeSubscriptionToOpen;
}

/** @deprecated use injectDependencies subscriptionType instead */
export const ChangeSubscriptionToPlatform = 'Device.Configuration.ChangeSubscriptionToPlatform';
export interface ChangeSubscriptionToPlatform {
	type: typeof ChangeSubscriptionToPlatform;
}

export interface IOptionalConfig<TUpdatedAt = string> {
	updatedAt: TUpdatedAt;
	baseUrl: string | null;
	platformUri: string | null;
	socketDriver: string | null;
	staticBaseUrl: string | null;
	uploadBaseUrl: string | null;
	weinreUri: string | null;
	/** @deprecated use UpdateExtendedManagementUrl action instead */
	extendedManagementUrl: string | null;
	subscriptionType: SubscriptionType | null;
	checkInterval: number | null;
	telemetryIntervals?: ITelemetryIntervals | null;
	checkTimeBeforeConnection?: boolean;
	offlineActionsLimits?: ActionsLimit | null;
	featureFlags?: DeviceFeatureFlagRecord | null;
}

export const ConfigurationChanged = 'Device.Configuration.ConfigurationChanged';
export interface ConfigurationChanged {
	type: typeof ConfigurationChanged;
	config: IOptionalConfig;
}

export const ConfigurationCheckFailed = 'Device.Configuration.ConfigurationCheckFailed';
export interface ConfigurationCheckFailed {
	type: typeof ConfigurationCheckFailed;
	error: Error | FetchError;
}
