declare const status: {
    444: "No Response";
    "444_NAME": "NO_RESPONSE";
    "444_MESSAGE": "Used internally to instruct the server to return no information to the client and close the connection immediately.";
    "444_CLASS": "4xx";
    NO_RESPONSE: 444;
    494: "Request header too large";
    "494_NAME": "REQUEST_HEADER_TOO_LARGE";
    "494_MESSAGE": "Client sent too large request or too long header line.";
    "494_CLASS": "4xx";
    REQUEST_HEADER_TOO_LARGE: 494;
    495: "SSL Certificate Error";
    "495_NAME": "SSL_CERTIFICATE_ERROR";
    "495_MESSAGE": "An expansion of the 400 Bad Request response code, used when the client has provided an invalid client certificate.";
    "495_CLASS": "4xx";
    SSL_CERTIFICATE_ERROR: 495;
    496: "SSL Certificate Required";
    "496_NAME": "SSL_CERTIFICATE_REQUIRED";
    "496_MESSAGE": "An expansion of the 400 Bad Request response code, used when a client certificate is required but not provided.";
    "496_CLASS": "4xx";
    SSL_CERTIFICATE_REQUIRED: 496;
    497: "HTTP Request Sent to HTTPS Port";
    "497_NAME": "HTTP_REQUEST_SENT_TO_HTTPS_PORT";
    "497_MESSAGE": "An expansion of the 400 Bad Request response code, used when the client has made a HTTP request to a port listening for HTTPS requests.";
    "497_CLASS": "4xx";
    HTTP_REQUEST_SENT_TO_HTTPS_PORT: 497;
    499: "Client Closed Request";
    "499_NAME": "CLIENT_CLOSED_REQUEST";
    "499_MESSAGE": "Used when the client has closed the request before the server could send a response.";
    "499_CLASS": "4xx";
    CLIENT_CLOSED_REQUEST: 499;
    classes: {
        readonly "1xx": "Informational";
        readonly "1xx_NAME": "INFORMATIONAL";
        readonly "1xx_MESSAGE": "Indicates an interim response for communicating connection status or request progress prior to completing the requested action and sending a final response.";
        readonly INFORMATIONAL: "1xx";
        readonly "2xx": "Successful";
        readonly "2xx_NAME": "SUCCESSFUL";
        readonly "2xx_MESSAGE": "Indicates that the client's request was successfully received, understood, and accepted.";
        readonly SUCCESSFUL: "2xx";
        readonly "3xx": "Redirection";
        readonly "3xx_NAME": "REDIRECTION";
        readonly "3xx_MESSAGE": "Indicates that further action needs to be taken by the user agent in order to fulfill the request.";
        readonly REDIRECTION: "3xx";
        readonly "4xx": "Client Error";
        readonly "4xx_NAME": "CLIENT_ERROR";
        readonly "4xx_MESSAGE": "Indicates that the client seems to have erred.";
        readonly CLIENT_ERROR: "4xx";
        readonly "5xx": "Server Error";
        readonly "5xx_NAME": "SERVER_ERROR";
        readonly "5xx_MESSAGE": "Indicates that the server is aware that it has erred or is incapable of performing the requested method.";
        readonly SERVER_ERROR: "5xx";
    };
    100: "Continue";
    "100_NAME": "CONTINUE";
    "100_MESSAGE": "The server has received the request headers and the client should proceed to send the request body.";
    "100_CLASS": "1xx";
    CONTINUE: 100;
    101: "Switching Protocols";
    "101_NAME": "SWITCHING_PROTOCOLS";
    "101_MESSAGE": "The requester has asked the server to switch protocols and the server has agreed to do so.";
    "101_CLASS": "1xx";
    SWITCHING_PROTOCOLS: 101;
    102: "Processing";
    "102_NAME": "PROCESSING";
    "102_MESSAGE": "A WebDAV request may contain many sub-requests involving file operations, requiring a long time to complete the request. This code indicates that the server has received and is processing the request, but no response is available yet.[7] This prevents the client from timing out and assuming the request was lost.";
    "102_CLASS": "1xx";
    PROCESSING: 102;
    103: "Early Hints";
    "103_NAME": "EARLY_HINTS";
    "103_MESSAGE": "Used to return some response headers before final HTTP message.";
    "103_CLASS": "1xx";
    EARLY_HINTS: 103;
    200: "OK";
    "200_NAME": "OK";
    "200_MESSAGE": "Standard response for successful HTTP requests.";
    "200_CLASS": "2xx";
    OK: 200;
    201: "Created";
    "201_NAME": "CREATED";
    "201_MESSAGE": "The request has been fulfilled, resulting in the creation of a new resource.";
    "201_CLASS": "2xx";
    CREATED: 201;
    202: "Accepted";
    "202_NAME": "ACCEPTED";
    "202_MESSAGE": "The request has been accepted for processing, but the processing has not been completed.";
    "202_CLASS": "2xx";
    ACCEPTED: 202;
    203: "Non-Authoritative Information";
    "203_NAME": "NON_AUTHORITATIVE_INFORMATION";
    "203_MESSAGE": "The server is a transforming proxy (e.g. a Web accelerator) that received a 200 OK from its origin, but is returning a modified version of the origin's response.";
    "203_CLASS": "2xx";
    NON_AUTHORITATIVE_INFORMATION: 203;
    204: "No Content";
    "204_NAME": "NO_CONTENT";
    "204_MESSAGE": "The server successfully processed the request and is not returning any content.";
    "204_CLASS": "2xx";
    NO_CONTENT: 204;
    205: "Reset Content";
    "205_NAME": "RESET_CONTENT";
    "205_MESSAGE": "The server successfully processed the request, but is not returning any content. Unlike a 204 response, this response requires that the requester reset the document view.";
    "205_CLASS": "2xx";
    RESET_CONTENT: 205;
    206: "Partial Content";
    "206_NAME": "PARTIAL_CONTENT";
    "206_MESSAGE": "The server is delivering only part of the resource (byte serving) due to a range header sent by the client.";
    "206_CLASS": "2xx";
    PARTIAL_CONTENT: 206;
    207: "Multi Status";
    "207_NAME": "MULTI_STATUS";
    "207_MESSAGE": "The message body that follows is by default an XML message and can contain a number of separate response codes, depending on how many sub-requests were made.";
    "207_CLASS": "2xx";
    MULTI_STATUS: 207;
    208: "Already Reported";
    "208_NAME": "ALREADY_REPORTED";
    "208_MESSAGE": "The members of a DAV binding have already been enumerated in a preceding part of the (multistatus) response, and are not being included again.";
    "208_CLASS": "2xx";
    ALREADY_REPORTED: 208;
    226: "IM Used";
    "226_NAME": "IM_USED";
    "226_MESSAGE": "The server has fulfilled a request for the resource, and the response is a representation of the result of one or more instance-manipulations applied to the current instance.";
    "226_CLASS": "2xx";
    IM_USED: 226;
    300: "Multiple Choices";
    "300_NAME": "MULTIPLE_CHOICES";
    "300_MESSAGE": "Indicates multiple options for the resource from which the client may choose.";
    "300_CLASS": "3xx";
    MULTIPLE_CHOICES: 300;
    301: "Moved Permanently";
    "301_NAME": "MOVED_PERMANENTLY";
    "301_MESSAGE": "This and all future requests should be directed to the given URI.";
    "301_CLASS": "3xx";
    MOVED_PERMANENTLY: 301;
    302: "Found";
    "302_NAME": "FOUND";
    "302_MESSAGE": "This is an example of industry practice contradicting the standard. The HTTP/1.0 specification (RFC 1945) required the client to perform a temporary redirect (the original describing phrase was \"Moved Temporarily\"), but popular browsers implemented 302 with the functionality of a 303 See Other. Therefore, HTTP/1.1 added status codes 303 and 307 to distinguish between the two behaviours.";
    "302_CLASS": "3xx";
    FOUND: 302;
    303: "See Other";
    "303_NAME": "SEE_OTHER";
    "303_MESSAGE": "The response to the request can be found under another URI using the GET method.";
    "303_CLASS": "3xx";
    SEE_OTHER: 303;
    304: "Not Modified";
    "304_NAME": "NOT_MODIFIED";
    "304_MESSAGE": "Indicates that the resource has not been modified since the version specified by the request headers If-Modified-Since or If-None-Match.";
    "304_CLASS": "3xx";
    NOT_MODIFIED: 304;
    305: "Use Proxy";
    "305_NAME": "USE_PROXY";
    "305_MESSAGE": "The requested resource is available only through a proxy, the address for which is provided in the response.";
    "305_CLASS": "3xx";
    USE_PROXY: 305;
    306: "Switch Proxy";
    "306_NAME": "SWITCH_PROXY";
    "306_MESSAGE": "No longer used. Originally meant \"Subsequent requests should use the specified proxy.";
    "306_CLASS": "3xx";
    SWITCH_PROXY: 306;
    307: "Temporary Redirect";
    "307_NAME": "TEMPORARY_REDIRECT";
    "307_MESSAGE": "In this case, the request should be repeated with another URI; however, future requests should still use the original URI.";
    "307_CLASS": "3xx";
    TEMPORARY_REDIRECT: 307;
    308: "Permanent Redirect";
    "308_NAME": "PERMANENT_REDIRECT";
    "308_MESSAGE": "The request and all future requests should be repeated using another URI.";
    "308_CLASS": "3xx";
    PERMANENT_REDIRECT: 308;
    400: "Bad Request";
    "400_NAME": "BAD_REQUEST";
    "400_MESSAGE": "The server cannot or will not process the request due to an apparent client error.";
    "400_CLASS": "4xx";
    BAD_REQUEST: 400;
    401: "Unauthorized";
    "401_NAME": "UNAUTHORIZED";
    "401_MESSAGE": "Similar to 403 Forbidden, but specifically for use when authentication is required and has failed or has not yet been provided.";
    "401_CLASS": "4xx";
    UNAUTHORIZED: 401;
    402: "Payment Required";
    "402_NAME": "PAYMENT_REQUIRED";
    "402_MESSAGE": "Reserved for future use. The original intention was that this code might be used as part of some form of digital cash or micropayment scheme, as proposed for example by GNU Taler, but that has not yet happened, and this code is not usually used.";
    "402_CLASS": "4xx";
    PAYMENT_REQUIRED: 402;
    403: "Forbidden";
    "403_NAME": "FORBIDDEN";
    "403_MESSAGE": "The request was valid, but the server is refusing action.";
    "403_CLASS": "4xx";
    FORBIDDEN: 403;
    404: "Not Found";
    "404_NAME": "NOT_FOUND";
    "404_MESSAGE": "The requested resource could not be found but may be available in the future. Subsequent requests by the client are permissible.";
    "404_CLASS": "4xx";
    NOT_FOUND: 404;
    405: "Method Not Allowed";
    "405_NAME": "METHOD_NOT_ALLOWED";
    "405_MESSAGE": "A request method is not supported for the requested resource.";
    "405_CLASS": "4xx";
    METHOD_NOT_ALLOWED: 405;
    406: "Not Acceptable";
    "406_NAME": "NOT_ACCEPTABLE";
    "406_MESSAGE": "The requested resource is capable of generating only content not acceptable according to the Accept headers sent in the request.";
    "406_CLASS": "4xx";
    NOT_ACCEPTABLE: 406;
    407: "Proxy Authentication Required";
    "407_NAME": "PROXY_AUTHENTICATION_REQUIRED";
    "407_MESSAGE": "The client must first authenticate itself with the proxy.";
    "407_CLASS": "4xx";
    PROXY_AUTHENTICATION_REQUIRED: 407;
    408: "Request Time-out";
    "408_NAME": "REQUEST_TIMEOUT";
    "408_MESSAGE": "The server timed out waiting for the request.";
    "408_CLASS": "4xx";
    REQUEST_TIMEOUT: 408;
    409: "Conflict";
    "409_NAME": "CONFLICT";
    "409_MESSAGE": "Indicates that the request could not be processed because of conflict in the request, such as an edit conflict between multiple simultaneous updates.";
    "409_CLASS": "4xx";
    CONFLICT: 409;
    410: "Gone";
    "410_NAME": "GONE";
    "410_MESSAGE": "Indicates that the resource requested is no longer available and will not be available again.";
    "410_CLASS": "4xx";
    GONE: 410;
    411: "Length Required";
    "411_NAME": "LENGTH_REQUIRED";
    "411_MESSAGE": "The request did not specify the length of its content, which is required by the requested resource.";
    "411_CLASS": "4xx";
    LENGTH_REQUIRED: 411;
    412: "Precondition Failed";
    "412_NAME": "PRECONDITION_FAILED";
    "412_MESSAGE": "The server does not meet one of the preconditions that the requester put on the request.";
    "412_CLASS": "4xx";
    PRECONDITION_FAILED: 412;
    413: "Request Entity Too Large";
    "413_NAME": "REQUEST_ENTITY_TOO_LARGE";
    "413_MESSAGE": "The request is larger than the server is willing or able to process. Previously called \"Request Entity Too Large\".";
    "413_CLASS": "4xx";
    REQUEST_ENTITY_TOO_LARGE: 413;
    414: "Request-URI Too Large";
    "414_NAME": "REQUEST_URI_TOO_LONG";
    "414_MESSAGE": "The URI provided was too long for the server to process.";
    "414_CLASS": "4xx";
    REQUEST_URI_TOO_LONG: 414;
    415: "Unsupported Media Type";
    "415_NAME": "UNSUPPORTED_MEDIA_TYPE";
    "415_MESSAGE": "The request entity has a media type which the server or resource does not support.";
    "415_CLASS": "4xx";
    UNSUPPORTED_MEDIA_TYPE: 415;
    416: "Requested Range not Satisfiable";
    "416_NAME": "REQUESTED_RANGE_NOT_SATISFIABLE";
    "416_MESSAGE": "The client has asked for a portion of the file (byte serving), but the server cannot supply that portion.";
    "416_CLASS": "4xx";
    REQUESTED_RANGE_NOT_SATISFIABLE: 416;
    417: "Expectation Failed";
    "417_NAME": "EXPECTATION_FAILED";
    "417_MESSAGE": "The server cannot meet the requirements of the Expect request-header field.";
    "417_CLASS": "4xx";
    EXPECTATION_FAILED: 417;
    418: "I'm a teapot";
    "418_NAME": "IM_A_TEAPOT";
    "418_MESSAGE": "Any attempt to brew coffee with a teapot should result in the error code \"418 I'm a teapot\". The resulting entity body MAY be short and stout.";
    "418_CLASS": "4xx";
    IM_A_TEAPOT: 418;
    421: "Misdirected Request";
    "421_NAME": "MISDIRECTED_REQUEST";
    "421_MESSAGE": "The request was directed at a server that is not able to produce a response.";
    "421_CLASS": "4xx";
    MISDIRECTED_REQUEST: 421;
    422: "Unprocessable Entity";
    "422_NAME": "UNPROCESSABLE_ENTITY";
    "422_MESSAGE": "The request was well-formed but was unable to be followed due to semantic errors.";
    "422_CLASS": "4xx";
    UNPROCESSABLE_ENTITY: 422;
    423: "Locked";
    "423_NAME": "LOCKED";
    "423_MESSAGE": "The resource that is being accessed is locked.";
    "423_CLASS": "4xx";
    LOCKED: 423;
    424: "Failed Dependency";
    "424_NAME": "FAILED_DEPENDENCY";
    "424_MESSAGE": "The request failed because it depended on another request and that request failed.";
    "424_CLASS": "4xx";
    FAILED_DEPENDENCY: 424;
    425: "Too Early";
    "425_NAME": "TOO_EARLY";
    "425_MESSAGE": "The server is unwilling to risk processing a request that might be replayed.";
    "425_CLASS": "4xx";
    TOO_EARLY: 425;
    426: "Upgrade Required";
    "426_NAME": "UPGRADE_REQUIRED";
    "426_MESSAGE": "The client should switch to a different protocol such as TLS/1.0, given in the Upgrade header field.";
    "426_CLASS": "4xx";
    UPGRADE_REQUIRED: 426;
    428: "Precondition Required";
    "428_NAME": "PRECONDITION_REQUIRED";
    "428_MESSAGE": "The origin server requires the request to be conditional.";
    "428_CLASS": "4xx";
    PRECONDITION_REQUIRED: 428;
    429: "Too Many Requests";
    "429_NAME": "TOO_MANY_REQUESTS";
    "429_MESSAGE": "The user has sent too many requests in a given amount of time.";
    "429_CLASS": "4xx";
    TOO_MANY_REQUESTS: 429;
    431: "Request Header Fields Too Large";
    "431_NAME": "REQUEST_HEADER_FIELDS_TOO_LARGE";
    "431_MESSAGE": "The server is unwilling to process the request because either an individual header field, or all the header fields collectively, are too large.";
    "431_CLASS": "4xx";
    REQUEST_HEADER_FIELDS_TOO_LARGE: 431;
    451: "Unavailable For Legal Reasons";
    "451_NAME": "UNAVAILABLE_FOR_LEGAL_REASONS";
    "451_MESSAGE": "A server operator has received a legal demand to deny access to a resource or to a set of resources that includes the requested resource.";
    "451_CLASS": "4xx";
    UNAVAILABLE_FOR_LEGAL_REASONS: 451;
    500: "Internal Server Error";
    "500_NAME": "INTERNAL_SERVER_ERROR";
    "500_MESSAGE": "A generic error message, given when an unexpected condition was encountered and no more specific message is suitable.";
    "500_CLASS": "5xx";
    INTERNAL_SERVER_ERROR: 500;
    501: "Not Implemented";
    "501_NAME": "NOT_IMPLEMENTED";
    "501_MESSAGE": "The server either does not recognize the request method, or it lacks the ability to fulfil the request. Usually this implies future availability.";
    "501_CLASS": "5xx";
    NOT_IMPLEMENTED: 501;
    502: "Bad Gateway";
    "502_NAME": "BAD_GATEWAY";
    "502_MESSAGE": "The server was acting as a gateway or proxy and received an invalid response from the upstream server.";
    "502_CLASS": "5xx";
    BAD_GATEWAY: 502;
    503: "Service Unavailable";
    "503_NAME": "SERVICE_UNAVAILABLE";
    "503_MESSAGE": "The server is currently unavailable (because it is overloaded or down for maintenance). Generally, this is a temporary state.";
    "503_CLASS": "5xx";
    SERVICE_UNAVAILABLE: 503;
    504: "Gateway Time-out";
    "504_NAME": "GATEWAY_TIMEOUT";
    "504_MESSAGE": "The server was acting as a gateway or proxy and did not receive a timely response from the upstream server.";
    "504_CLASS": "5xx";
    GATEWAY_TIMEOUT: 504;
    505: "HTTP Version not Supported";
    "505_NAME": "HTTP_VERSION_NOT_SUPPORTED";
    "505_MESSAGE": "The server does not support the HTTP protocol version used in the request.";
    "505_CLASS": "5xx";
    HTTP_VERSION_NOT_SUPPORTED: 505;
    506: "Variant Also Negotiates";
    "506_NAME": "VARIANT_ALSO_NEGOTIATES";
    "506_MESSAGE": "Transparent content negotiation for the request results in a circular reference.";
    "506_CLASS": "5xx";
    VARIANT_ALSO_NEGOTIATES: 506;
    507: "Insufficient Storage";
    "507_NAME": "INSUFFICIENT_STORAGE";
    "507_MESSAGE": "The server is unable to store the representation needed to complete the request.";
    "507_CLASS": "5xx";
    INSUFFICIENT_STORAGE: 507;
    508: "Loop Detected";
    "508_NAME": "LOOP_DETECTED";
    "508_MESSAGE": "The server detected an infinite loop while processing the request.";
    "508_CLASS": "5xx";
    LOOP_DETECTED: 508;
    510: "Not Extended";
    "510_NAME": "NOT_EXTENDED";
    "510_MESSAGE": "Further extensions to the request are required for the server to fulfil it.";
    "510_CLASS": "5xx";
    NOT_EXTENDED: 510;
    511: "Network Authentication Required";
    "511_NAME": "NETWORK_AUTHENTICATION_REQUIRED";
    "511_MESSAGE": "The client needs to authenticate to gain network access. Intended for use by intercepting proxies used to control access to the network.";
    "511_CLASS": "5xx";
    NETWORK_AUTHENTICATION_REQUIRED: 511;
    extra: {
        readonly unofficial: {
            readonly 103: "Checkpoint";
            readonly "103_NAME": "CHECKPOINT";
            readonly "103_MESSAGE": "Used in the resumable requests proposal to resume aborted PUT or POST requests.";
            readonly "103_CLASS": "1xx";
            readonly CHECKPOINT: 103;
            readonly 419: "Page Expired";
            readonly "419_NAME": "PAGE_EXPIRED";
            readonly "419_MESSAGE": "Used by the Laravel Framework when a CSRF Token is missing or expired.";
            readonly "419_CLASS": "4xx";
            readonly PAGE_EXPIRED: 419;
            readonly 218: "This is fine";
            readonly "218_NAME": "THIS_IS_FINE";
            readonly "218_MESSAGE": "Used as a catch-all error condition for allowing response bodies to flow through Apache when ProxyErrorOverride is enabled. When ProxyErrorOverride is enabled in Apache, response bodies that contain a status code of 4xx or 5xx are automatically discarded by Apache in favor of a generic response or a custom response specified by the ErrorDocument directive.";
            readonly "218_CLASS": "2xx";
            readonly THIS_IS_FINE: 218;
            readonly 420: "Enhance Your Calm";
            readonly "420_NAME": "ENHANCE_YOUR_CALM";
            readonly "420_MESSAGE": "Returned by version 1 of the Twitter Search and Trends API when the client is being rate limited; versions 1.1 and later use the 429 Too Many Requests response code instead.";
            readonly "420_CLASS": "4xx";
            readonly ENHANCE_YOUR_CALM: 420;
            readonly 450: "Blocked by Windows Parental Controls";
            readonly "450_NAME": "BLOCKED_BY_WINDOWS_PARENTAL_CONTROLS";
            readonly "450_MESSAGE": "The Microsoft extension code indicated when Windows Parental Controls are turned on and are blocking access to the requested webpage.";
            readonly "450_CLASS": "4xx";
            readonly BLOCKED_BY_WINDOWS_PARENTAL_CONTROLS: 450;
            readonly 498: "Invalid Token";
            readonly "498_NAME": "INVALID_TOKEN";
            readonly "498_MESSAGE": "Returned by ArcGIS for Server. Code 498 indicates an expired or otherwise invalid token.";
            readonly "498_CLASS": "4xx";
            readonly INVALID_TOKEN: 498;
            readonly 499: "Token Required";
            readonly "499_NAME": "TOKEN_REQUIRED";
            readonly "499_MESSAGE": "Returned by ArcGIS for Server. Code 499 indicates that a token is required but was not submitted.";
            readonly "499_CLASS": "4xx";
            readonly TOKEN_REQUIRED: 499;
            readonly 509: "Bandwidth Limit Exceeded";
            readonly "509_NAME": "BANDWIDTH_LIMIT_EXCEEDED";
            readonly "509_MESSAGE": "The server has exceeded the bandwidth specified by the server administrator.";
            readonly "509_CLASS": "5xx";
            readonly BANDWIDTH_LIMIT_EXCEEDED: 509;
            readonly 530: "Site is frozen";
            readonly "530_NAME": "SITE_IS_FROZEN";
            readonly "530_MESSAGE": "Used by the Pantheon web platform to indicate a site that has been frozen due to inactivity.";
            readonly "530_CLASS": "5xx";
            readonly SITE_IS_FROZEN: 530;
            readonly 598: "Network read timeout error";
            readonly "598_NAME": "NETWORK_READ_TIMEOUT_ERROR";
            readonly "598_MESSAGE": "Used by some HTTP proxies to signal a network read timeout behind the proxy to a client in front of the proxy.";
            readonly "598_CLASS": "5xx";
            readonly NETWORK_READ_TIMEOUT_ERROR: 598;
        };
        readonly iis: {
            readonly 440: "Login Time-out";
            readonly "440_NAME": "LOGIN_TIME_OUT";
            readonly "440_MESSAGE": "The client's session has expired and must log in again.";
            readonly "440_CLASS": "4xx";
            readonly LOGIN_TIME_OUT: 440;
            readonly 449: "Retry With";
            readonly "449_NAME": "RETRY_WITH";
            readonly "449_MESSAGE": "The server cannot honour the request because the user has not provided the required information.";
            readonly "449_CLASS": "4xx";
            readonly RETRY_WITH: 449;
            readonly 451: "Redirect";
            readonly "451_NAME": "REDIRECT";
            readonly "451_MESSAGE": "Used in Exchange ActiveSync when either a more efficient server is available or the server cannot access the users' mailbox.";
            readonly "451_CLASS": "4xx";
            readonly REDIRECT: 451;
        };
        readonly nginx: {
            readonly 444: "No Response";
            readonly "444_NAME": "NO_RESPONSE";
            readonly "444_MESSAGE": "Used internally to instruct the server to return no information to the client and close the connection immediately.";
            readonly "444_CLASS": "4xx";
            readonly NO_RESPONSE: 444;
            readonly 494: "Request header too large";
            readonly "494_NAME": "REQUEST_HEADER_TOO_LARGE";
            readonly "494_MESSAGE": "Client sent too large request or too long header line.";
            readonly "494_CLASS": "4xx";
            readonly REQUEST_HEADER_TOO_LARGE: 494;
            readonly 495: "SSL Certificate Error";
            readonly "495_NAME": "SSL_CERTIFICATE_ERROR";
            readonly "495_MESSAGE": "An expansion of the 400 Bad Request response code, used when the client has provided an invalid client certificate.";
            readonly "495_CLASS": "4xx";
            readonly SSL_CERTIFICATE_ERROR: 495;
            readonly 496: "SSL Certificate Required";
            readonly "496_NAME": "SSL_CERTIFICATE_REQUIRED";
            readonly "496_MESSAGE": "An expansion of the 400 Bad Request response code, used when a client certificate is required but not provided.";
            readonly "496_CLASS": "4xx";
            readonly SSL_CERTIFICATE_REQUIRED: 496;
            readonly 497: "HTTP Request Sent to HTTPS Port";
            readonly "497_NAME": "HTTP_REQUEST_SENT_TO_HTTPS_PORT";
            readonly "497_MESSAGE": "An expansion of the 400 Bad Request response code, used when the client has made a HTTP request to a port listening for HTTPS requests.";
            readonly "497_CLASS": "4xx";
            readonly HTTP_REQUEST_SENT_TO_HTTPS_PORT: 497;
            readonly 499: "Client Closed Request";
            readonly "499_NAME": "CLIENT_CLOSED_REQUEST";
            readonly "499_MESSAGE": "Used when the client has closed the request before the server could send a response.";
            readonly "499_CLASS": "4xx";
            readonly CLIENT_CLOSED_REQUEST: 499;
        };
        readonly cloudflare: {
            readonly 520: "Unknown Error";
            readonly "520_NAME": "UNKNOWN_ERROR";
            readonly "520_MESSAGE": "The 520 error is used as a \"catch-all response for when the origin server returns something unexpected\", listing connection resets, large headers, and empty or invalid responses as common triggers.";
            readonly "520_CLASS": "5xx";
            readonly UNKNOWN_ERROR: 520;
            readonly 521: "Web Server Is Down";
            readonly "521_NAME": "WEB_SERVER_IS_DOWN";
            readonly "521_MESSAGE": "The origin server has refused the connection from Cloudflare.";
            readonly "521_CLASS": "5xx";
            readonly WEB_SERVER_IS_DOWN: 521;
            readonly 522: "Connection Timed Out";
            readonly "522_NAME": "CONNECTION_TIMED_OUT";
            readonly "522_MESSAGE": "Cloudflare could not negotiate a TCP handshake with the origin server.";
            readonly "522_CLASS": "5xx";
            readonly CONNECTION_TIMED_OUT: 522;
            readonly 523: "Origin Is Unreachable";
            readonly "523_NAME": "ORIGIN_IS_UNREACHABLE";
            readonly "523_MESSAGE": "Cloudflare could not reach the origin server.";
            readonly "523_CLASS": "5xx";
            readonly ORIGIN_IS_UNREACHABLE: 523;
            readonly 524: "A Timeout Occurred";
            readonly "524_NAME": "A_TIMEOUT_OCCURRED";
            readonly "524_MESSAGE": "Cloudflare was able to complete a TCP connection to the origin server, but did not receive a timely HTTP response.";
            readonly "524_CLASS": "5xx";
            readonly A_TIMEOUT_OCCURRED: 524;
            readonly 525: "SSL Handshake Failed";
            readonly "525_NAME": "SSL_HANDSHAKE_FAILED";
            readonly "525_MESSAGE": "Cloudflare could not negotiate a SSL/TLS handshake with the origin server.";
            readonly "525_CLASS": "5xx";
            readonly SSL_HANDSHAKE_FAILED: 525;
            readonly 526: "Invalid SSL Certificate";
            readonly "526_NAME": "INVALID_SSL_CERTIFICATE";
            readonly "526_MESSAGE": "Cloudflare could not validate the SSL/TLS certificate that the origin server presented.";
            readonly "526_CLASS": "5xx";
            readonly INVALID_SSL_CERTIFICATE: 526;
            readonly 527: "Railgun Error";
            readonly "527_NAME": "RAILGUN_ERROR";
            readonly "527_MESSAGE": "Error 527 indicates that the request timed out or failed after the WAN connection had been established.";
            readonly "527_CLASS": "5xx";
            readonly RAILGUN_ERROR: 527;
        };
    };
};

export { status as default, status };
