"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const path = __importStar(require("path"));
const fs = __importStar(require("fs-extra"));
const tar = __importStar(require("tar"));
const tmp = __importStar(require("tmp"));
const child_process_1 = require("child_process");
class NpmPackPlugin {
    constructor(options) {
        this.options = options;
    }
    apply(compiler) {
        const hook = () => {
            if (this.options.environment === 'dev') {
                const timestampNumber = new Date().toISOString().replace(/[^\d]/gi, '').substr(0, 14);
                const devVersion = (this.options.getVersion ? this.options.getVersion() : '99.0.0-dev') + '.' + timestampNumber;
                const tmpDir = tmp.dirSync().name;
                fs.copySync(path.join(this.options.rootPath, 'dist'), path.join(tmpDir, 'package', 'dist'));
                fs.copySync(path.join(this.options.rootPath, 'README.md'), path.join(tmpDir, 'package', 'README.md'));
                const configPath = path.join(this.options.rootPath, 'package.json');
                const configContents = fs.readJSONSync(configPath);
                configContents.version = devVersion;
                fs.writeJSONSync(path.join(tmpDir, 'package', 'package.json'), configContents);
                const tarballDir = path.join(this.options.packagesPath, this.options.name, devVersion);
                const tarballFileName = this.options.name.replace(/^@/, '').replace(/\//g, '-') + '-' + devVersion + '.tgz';
                fs.ensureDirSync(tarballDir);
                tar.c({
                    gzip: true,
                    file: path.join(tarballDir, tarballFileName),
                    sync: true,
                    cwd: tmpDir,
                }, ['package']);
                this.packDependencies();
                console.info('Tarball release ' + tarballFileName);
            }
        };
        if ('plugin' in compiler && typeof compiler.plugin === 'function') {
            compiler.plugin('done', hook);
        }
        else {
            compiler.hooks.done.tapAsync({ name: 'NpmPackPlugin' }, hook);
        }
    }
    packDependencies() {
        const configLockPath = path.join(this.options.rootPath, 'package-lock.json');
        const configLockContents = fs.readJSONSync(configLockPath);
        const dependencies = this.options.dependencies || [];
        for (const dependency of dependencies) {
            const dependencyVersion = 'dependencies' in configLockContents
                ? // lockfileVersion 0 and 1
                    configLockContents.dependencies[dependency].version
                : // lockfileVersion 2 and 3
                    configLockContents.packages['node_modules/' + dependency].version;
            const dependencyVersionPath = path.join(this.options.packagesPath, dependency, dependencyVersion);
            if (!fs.existsSync(dependencyVersionPath)) {
                const fileName = (0, child_process_1.execSync)(`npm pack ${dependency}@${dependencyVersion}`).toString().trim();
                fs.ensureDirSync(dependencyVersionPath);
                fs.moveSync(path.join(this.options.rootPath, fileName), path.join(dependencyVersionPath, fileName));
            }
        }
    }
}
exports.default = NpmPackPlugin;
//# sourceMappingURL=NpmPackPlugin.js.map