"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initDbConnectionsMetrics = initDbConnectionsMetrics;
const connection_1 = require("../../ThirdParty/connection");
const mongodb_1 = require("./mongodb");
function initDbConnectionsMetrics(connections, metricsClient) {
    if (connections.amqp) {
        initMetricsForDBType(metricsClient, 'amqp', connections.amqp);
    }
    if (connections.redis) {
        initMetricsForDBType(metricsClient, 'redis', connections.redis);
    }
    if (connections.postgres) {
        initMetricsForDBType(metricsClient, 'postgres', connections.postgres);
    }
    if (connections.mongodb) {
        (0, mongodb_1.initMongoDBConnectionsMetrics)(metricsClient, connections.mongodb);
    }
}
function initMetricsForDBType(metricsClient, dbName, connections) {
    const client = metricsClient.getClient();
    for (const connName of Object.keys(connections)) {
        const connection = connections[connName];
        const metricPrefix = `sos_service_db_connections_${dbName}_${connName}_`;
        const openMetric = new client.Gauge({
            name: metricPrefix + 'open',
            help: 'Count of open AMQP connections for the entire runtime history',
        });
        const closeMetric = new client.Gauge({
            name: metricPrefix + 'close',
            help: 'Count of closed AMQP connections for the entire runtime history',
        });
        updateMetricWithConnection(connection, openMetric, closeMetric);
    }
}
function updateMetricWithConnection(connection, openMetric, closeMetric) {
    connection.addListener(connection_1.ThirdPartyConnectionEvent.ConnectionOpen, () => {
        openMetric.inc();
    });
    connection.addListener(connection_1.ThirdPartyConnectionEvent.ConnectionClosed, () => {
        closeMetric.inc();
    });
}
//# sourceMappingURL=connections.js.map