import { IMetricsClient } from '../../Metrics/MetricsClient';
import { DBConnections } from '../dbConnections';
import { IHttpServer } from '../types';
import { IsReadyCallback } from './routes/monitoring/readniness';
import { IsAliveCallback } from './routes/monitoring/aliveness';
import { AccessLogCallback } from './express/app';
export interface ServiceInfo {
    uid: string;
    name: string;
    version: string;
}
/**
 * Creates a HTTP server
 *
 * Serves some routes out of the box, that are common for all services:
 *   /         HTML index page with company logo
 *   /status   Returns some basic human-readable information about the service
 *   /ready    Responds with 200 if service is ready to serve requests,
 *              typically used by Kubernetes readiness probe
 *   /metrics  Metrics endpoint for Prometheus
 *
 * This factory returns a router, that can be used to add more routes.
 */
export declare function createHttpServer({ service, port, monitoringPort, metricsClient, connections, isReady, isAlive, accessLogCallback, noRouteIndex, }: {
    service: ServiceInfo;
    port: number;
    monitoringPort: number;
    connections?: DBConnections;
    metricsClient: IMetricsClient;
    isReady?: IsReadyCallback;
    isAlive?: IsAliveCallback;
    /**
     * Custom callback to modify the access log before it is logged
     *
     * Use it to add custom fields to the access log.
     * It's not possible to modify the access log directly, only to add additional fields.
     *
     * @returns metadata object that will be merged with the access log
     */
    accessLogCallback?: AccessLogCallback;
    /**
     * Prevent serving the index page on / path
     */
    noRouteIndex?: boolean;
}): IHttpServer;
