export interface IDeferredStream<T> {
    resolve: (value: T) => void;
    reject: (error: Error) => void;
    promise: Promise<T>;
    value: T | undefined;
    iterator: () => AsyncIterableIterator<T>;
}
/**
 * It creates outside controlled promise/async iterator, similar to createDeferred, but may be more than once.
 * It does not guarantee that every resolved value is awaited and it only holds the current one.
 * Similar to Promise.withResolvers(), but throws when resolved multiple times.
 */
export declare const createDeferredStream: <T>() => IDeferredStream<T>;
