"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NpmClient = void 0;
const child_process_1 = require("child_process");
const util_1 = require("util");
const path = __importStar(require("path"));
const async_lock_1 = __importDefault(require("async-lock"));
const fs = __importStar(require("fs-extra"));
const debug_1 = __importDefault(require("debug"));
const debugDecorator_1 = require("../Debug/debugDecorator");
const NpmCredentialsProvider_1 = require("./NpmCredentialsProvider");
const DEBUG_NAMESPACE = '@signageos/lib:Npm:NpmClient';
const logDebug = (0, debug_1.default)(DEBUG_NAMESPACE);
const execAsync = (0, util_1.promisify)(child_process_1.exec);
class NpmClient {
    constructor(credentialsProvider = (0, NpmCredentialsProvider_1.createDefaultNpmCredentialsProvider)()) {
        this.credentialsProvider = credentialsProvider;
        this.lock = new async_lock_1.default();
    }
    getPackageVersions(packageName) {
        return __awaiter(this, void 0, void 0, function* () {
            const result = yield this.execNpmCommand({
                command: 'info',
                args: [packageName, 'versions', '--json'],
            });
            const resultParsed = JSON.parse(result);
            if (typeof resultParsed === 'string') {
                return [resultParsed];
            }
            else {
                return resultParsed;
            }
        });
    }
    downloadPackage(_a) {
        return __awaiter(this, arguments, void 0, function* ({ packageName, downloadPath, version }) {
            const lockKey = version ? `${packageName}.${version}` : packageName;
            return yield this.lock.acquire(lockKey, () => __awaiter(this, void 0, void 0, function* () {
                const packageWithVersion = version ? `${packageName}@${version}` : packageName;
                const fileName = yield this.execNpmCommand({
                    command: 'pack',
                    args: [packageWithVersion],
                });
                const srcPath = path.join(process.cwd(), fileName.trim());
                const destPath = path.join(downloadPath, fileName.trim());
                yield fs.move(srcPath, destPath);
                return destPath;
            }));
        });
    }
    execNpmCommand(_a) {
        return __awaiter(this, arguments, void 0, function* ({ command, args }) {
            const credentials = yield this.credentialsProvider();
            const argsString = this.addVerboseLoggingToArgs(args).join(' ');
            const fullCommand = `npm ${command} ${argsString}`;
            const { stdout, stderr } = yield execAsync(fullCommand, {
                env: {
                    PATH: process.env.PATH, // has to be here, otherwise can't find npm bin
                    NPM_REGISTRY_HOST: credentials.host,
                    NPM_REGISTRY_URL: credentials.url,
                    NPM_AUTH_TOKEN: credentials.authToken,
                },
            });
            if (stdout) {
                logDebug(`exec command: ${fullCommand}`, stdout);
            }
            if (stderr) {
                logDebug(`exec command: ${fullCommand}`, stderr);
            }
            return stdout;
        });
    }
    addVerboseLoggingToArgs(args) {
        if (args === undefined) {
            return ['--dd'];
        }
        return args.find((arg) => arg.includes('verbose') || arg === '--dd') ? args : [...args, '--dd'];
    }
}
exports.NpmClient = NpmClient;
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], NpmClient.prototype, "getPackageVersions", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], NpmClient.prototype, "downloadPackage", null);
//# sourceMappingURL=NpmClient.js.map