/**
 * Same as regular NodeJS EventEmitter, but accepts async listeners.
 */
export declare class AsyncEventEmitter {
    private listeners;
    /**
     * Adds a listener for the event. The listener will be called every time the event is emitted. The listener may be async.
     */
    on(event: string, listener: Function): this;
    /**
     * Adds a listener for the event. The listener will be called only once, the first time the event is emitted. The listener may be async.
     */
    once(event: string, listener: Function): this;
    /**
     * Removes a listener for the event.
     */
    off(event: string, listener: Function): this;
    /**
     * Alias for `on`.
     */
    addListener(event: string, listener: Function): this;
    /**
     * Alias for `off`.
     */
    removeListener(event: string, listener: Function): this;
    /**
     * Emits event and resolves, once all listeners have resolved.
     */
    emit(event: string, ...args: any[]): Promise<void>;
    private addNewListener;
}
