"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.debugClass = debugClass;
const debug_1 = __importDefault(require("debug"));
const debugDecorator_1 = require("./debugDecorator");
/**
 * Add to a class to debug all its method. Based on https://www.typescriptlang.org/docs/handbook/decorators.html#class-decorators
 *
 * For more information see https://www.npmjs.com/package/debug
 *
 * @param namespace Namespace of the debug logs. Run program with env variable DEBUG=<namespace> to enable the logs.
 */
function debugClass(namespace, debugFactory = debug_1.default) {
    const debugMethod = (0, debugDecorator_1.createDebugMethod)(debugFactory(namespace));
    return function (Target) {
        return class extends Target {
            constructor(...constructorArgs) {
                const list = Object.getOwnPropertyNames(Target.prototype);
                for (const methodName of list) {
                    const originalMethod = Target.prototype[methodName];
                    Target.prototype[methodName] = function (...args) {
                        return debugMethod(originalMethod, this, `${Target.name}:${methodName}`, args);
                    };
                }
                super(...constructorArgs);
            }
        };
    };
}
//# sourceMappingURL=debugClassDecorator.js.map