"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const async_lock_1 = __importDefault(require("async-lock"));
class QueueRepeatableSubscription {
    constructor(subscribeCallback) {
        this.subscribeCallback = subscribeCallback;
        this.subscribed = false;
        this.canceled = false;
        this.retryTimeout = null;
        this.asyncLock = new async_lock_1.default();
        this.cancelSubscription = () => __awaiter(this, void 0, void 0, function* () {
            return () => __awaiter(this, void 0, void 0, function* () {
                /* do nothing */
            });
        });
    }
    subscribe() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.subscribed) {
                throw new Error('Trying to subscribe already subscribed QueueRepeatableSubscription');
            }
            this.subscribed = true;
            yield this.subscribeOrRepeatIfFailed();
        });
    }
    cancel() {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.subscribed) {
                throw new Error("Trying to cancel QueueRepeatableSubscription which isn't subscribed");
            }
            return yield this.asyncLock.acquire('subscribe', () => __awaiter(this, void 0, void 0, function* () {
                this.canceled = true;
                if (this.retryTimeout !== null) {
                    clearTimeout(this.retryTimeout);
                    this.retryTimeout = null;
                }
                return yield this.cancelSubscription();
            }));
        });
    }
    subscribeOrRepeatIfFailed() {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                yield this.asyncLock.acquire('subscribe', () => __awaiter(this, void 0, void 0, function* () {
                    if (!this.canceled) {
                        this.cancelSubscription = yield this.subscribeCallback(() => this.repeatSubscription());
                    }
                }));
            }
            catch (error) {
                this.repeatSubscription();
            }
        });
    }
    repeatSubscription() {
        const RETRY_TIMEOUT = Math.round(Math.random() * 10e3);
        if (!this.canceled) {
            this.retryTimeout = setTimeout(() => __awaiter(this, void 0, void 0, function* () {
                yield this.subscribeOrRepeatIfFailed();
            }), RETRY_TIMEOUT);
        }
    }
}
exports.default = QueueRepeatableSubscription;
//# sourceMappingURL=QueueRepeatableSubscription.js.map