import { IDeferred } from '../../../Promise/deferred';
/**
 * DeferredState is a helper class for managing deferred promises for the LockedEventConsumer.
 * It allows to manage internal map of deferred promises for each lock-key.
 */
export declare class DeferredState {
    private deferredMap;
    /**
     * Create a deferred for the current lock-keys and push it to the list for subsequent promises to wait on.
     */
    addDeferred(lockKeys: string[]): IDeferred<void>;
    /**
     * Remove the deferred from the list for the given lock-keys.
     * If the list becomes empty, remove it from the map (cleanup).
     */
    removeDeferred(lockKeys: string[], deferred: IDeferred<void>): void;
    /**
     * Get a list of promises for all previously created deferred with the same lock-keys.
     */
    getPreviousPromises(lockKeys: string[]): Promise<void>[];
}
