"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = createSocket;
var socket_io_client_1 = __importDefault(require("socket.io-client"));
var url = __importStar(require("url"));
function createSocket(socketUri, onConnected, onDisconnected, onError) {
    var parsedSocketUrl = url.parse(socketUri);
    var pathname = parsedSocketUrl.pathname;
    var socketUrl = parsedSocketUrl.protocol + '//' + parsedSocketUrl.host;
    var socketIoPath = (pathname + '/socket.io').replace(/\/+/g, '/');
    var socket = (0, socket_io_client_1.default)(socketUrl, {
        path: socketIoPath,
        forceNew: true,
        upgrade: false,
        rememberUpgrade: true,
        transports: ['websocket'],
        reconnection: false,
        timeout: 5e3,
    });
    socket.on('connect_error', function (error) { return onError(error); });
    socket.on('error', function (error) { return onError(error); });
    socket.on('connection', function () { return onConnected(); });
    socket.on('disconnect', function () { return onDisconnected(); });
    return {
        on: function (event, listener) {
            socket.on(event, function (message, callback) {
                listener(message);
                if (callback) {
                    callback();
                }
            });
        },
        once: function (event, listener) {
            socket.once(event, function (message, callback) {
                listener(message);
                if (callback) {
                    callback();
                }
            });
        },
        emit: function (event, message, callback) {
            socket.emit(event, message, callback);
        },
        removeListener: function (event, listener) {
            socket.off(event, listener);
        },
        removeAllListeners: function () {
            socket.removeAllListeners();
        },
        close: function () {
            socket.close();
        },
    };
}
//# sourceMappingURL=createSocketIOSocket.js.map