import * as express from 'express';
import { AccessLog } from '../middleware/accessLogMiddleware';
import { ServiceInfo } from '../httpServerFactory';
import { DBConnections } from '../../dbConnections';
import { IMetricsClient } from '../../../Metrics/MetricsClient';
export type AccessLogCallback = (accessLog: AccessLog, req: express.Request, res: express.Response) => object;
export declare function createAppExpress(args: {
    service: ServiceInfo;
    metricsClient: IMetricsClient;
    connections?: DBConnections;
    /**
     * Custom callback to modify the access log before it is logged
     *
     * Use it to add custom fields to the access log.
     * It's not possible to modify the access log directly, only to add additional fields.
     *
     * @returns metadata object that will be merged with the access log
     */
    accessLogCallback?: AccessLogCallback;
    /**
     * Prevent serving the index page on / path
     */
    noRouteIndex?: boolean;
}): import("express-serve-static-core").Express;
