import { NpmCredentialsProvider } from './NpmCredentialsProvider';
import { DownloadPackageArgs, INpmClient } from './INpmClient';
export declare class NpmClient implements INpmClient {
    private credentialsProvider;
    private lock;
    constructor(credentialsProvider?: NpmCredentialsProvider);
    getPackageVersions(packageName: string): Promise<string[]>;
    downloadPackage({ packageName, downloadPath, version }: DownloadPackageArgs): Promise<string>;
    execNpmCommand({ command, args }: {
        command: string;
        args?: string[];
    }): Promise<string>;
    private addVerboseLoggingToArgs;
}
