import { Response } from 'express';
import * as prometheusClient from 'prom-client';
export type PrometheusClient = typeof prometheusClient;
export type BeforeServeListener = (client: PrometheusClient) => void;
/**
 * Metrics client
 *
 * If you want to add custom application-specific metrics, you have to call getClient()
 * add your metrics to the client.
 *
 * Example:
 *
 *  const client = metricsClient.getClient();
 *  const myCounter = new client.Counter({
 *    name: 'my_counter',
 *    help: 'This is my counter',
 *  });
 *  // now you can independently increment the counter in your code
 *  // and the value will automatically be exposed when serving metrics
 *
 * For more info, see https://www.npmjs.com/package/prom-client
 */
export interface IMetricsClient {
    /**
     * Returns Prometheus client
     *
     * This is useful for adding custom metrics
     */
    getClient(): PrometheusClient;
    /**
     * Initialize metrics client to start serving default Node.js metrics
     */
    init(): void;
    /** Serve metrics as HTTP response */
    serve(response: Response): Promise<Response>;
    /** Clear all metrics and reset the client */
    clear(): void;
}
export declare class MetricsClient implements IMetricsClient {
    private client;
    constructor(client?: PrometheusClient);
    getClient(): PrometheusClient;
    init(): void;
    serve(response: Response): Promise<Response>;
    clear(): void;
}
