"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WinstonLogger = void 0;
var WinstonLogger = /** @class */ (function () {
    function WinstonLogger(logger, namespace) {
        this.logger = logger;
        this.namespace = namespace;
        this.settings = {
            ignoredLogNamespaces: [],
        };
        this.settings = {
            ignoredLogNamespaces: typeof process.env.IGNORED_LOG_NAMESPACES !== 'undefined' ? process.env.IGNORED_LOG_NAMESPACES.split(',') : [],
        };
    }
    WinstonLogger.prototype.error = function (message, meta) {
        this.log('error', message, meta);
        return this;
    };
    WinstonLogger.prototype.warn = function (message, meta) {
        this.log('warn', message, meta);
        return this;
    };
    WinstonLogger.prototype.info = function (message, meta) {
        this.log('info', message, meta);
        return this;
    };
    WinstonLogger.prototype.debug = function (message, meta) {
        this.log('debug', message, meta);
        return this;
    };
    WinstonLogger.prototype.createNamespace = function (namespace) {
        var prefix = this.namespace ? "".concat(this.namespace, ":") : '';
        return new WinstonLogger(this.logger, prefix + namespace);
    };
    WinstonLogger.prototype.setIgnoredLogNamespaces = function (ignoredLogNamespaces) {
        this.settings.ignoredLogNamespaces = ignoredLogNamespaces;
    };
    /**
     * Log a message with the given level
     *
     * Logging can be disabled for specific namespaces by setting the `IGNORED_LOG_NAMESPACES` environment variable.
     */
    WinstonLogger.prototype.log = function (level, message, meta) {
        var ignoreLogs = typeof this.namespace !== 'undefined' && this.settings.ignoredLogNamespaces.includes(this.namespace);
        if (!ignoreLogs) {
            this.logger.log(level, message, __assign({ namespace: this.namespace }, meta));
        }
    };
    return WinstonLogger;
}());
exports.WinstonLogger = WinstonLogger;
//# sourceMappingURL=logger.js.map