"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getStringValuesRecursive = getStringValuesRecursive;
exports.getModuleExportsRecursive = getModuleExportsRecursive;
var fs = __importStar(require("fs"));
function getStringValuesRecursive(path) {
    var dirs = fs.readdirSync(path);
    var values = [];
    for (var _i = 0, dirs_1 = dirs; _i < dirs_1.length; _i++) {
        var dir = dirs_1[_i];
        var filePath = path + '/' + dir;
        var stats = fs.statSync(filePath);
        if (stats.isDirectory()) {
            values = __spreadArray(__spreadArray([], values, true), getStringValuesRecursive(filePath), true);
        }
        else if (dir.substr(dir.lastIndexOf('.')) === '.js') {
            var module_1 = require(filePath);
            for (var name_1 in module_1) {
                if (typeof module_1[name_1] === 'string') {
                    values = __spreadArray(__spreadArray([], values, true), [module_1[name_1]], false);
                }
            }
        }
    }
    return values;
}
function getModuleExportsRecursive(path, relativeBasePath) {
    if (relativeBasePath === void 0) { relativeBasePath = '.'; }
    var dirs = fs.readdirSync(path);
    var moduleExports = [];
    for (var _i = 0, dirs_2 = dirs; _i < dirs_2.length; _i++) {
        var dir = dirs_2[_i];
        var filePath = path + '/' + dir;
        var stats = fs.statSync(filePath);
        if (stats.isDirectory()) {
            moduleExports = __spreadArray(__spreadArray([], moduleExports, true), getModuleExportsRecursive(filePath, relativeBasePath + '/' + dir), true);
        }
        else if (dir.substr(dir.lastIndexOf('.')) === '.js') {
            var relativePath = relativeBasePath + '/' + dir.substr(0, dir.lastIndexOf('.'));
            var module_2 = require(filePath);
            for (var name_2 in module_2) {
                moduleExports = __spreadArray(__spreadArray([], moduleExports, true), [
                    {
                        relativePath: relativePath,
                        export: name_2,
                        value: module_2[name_2],
                    },
                ], false);
            }
        }
    }
    return moduleExports;
}
//# sourceMappingURL=moduleDiscoverer.js.map